import os
import json
import random

# 文件路径
train_json_path   = '/fs/scratch/PAS2099/Jiacheng/Orientation/train_v2/train.json'
val_json_path     = '/fs/scratch/PAS2099/Jiacheng/Orientation/val_v2/val.json'
val_ans_json_path = '/fs/scratch/PAS2099/Jiacheng/Orientation/val_v2/val_ans.json'

# 1. 加载 train.json
with open(train_json_path, 'r') as f:
    train_data = json.load(f)

# 2. 随机打乱 train 样本
random.shuffle(train_data)

# 3. 写回 train.json
with open(train_json_path, 'w') as f:
    json.dump(train_data, f, indent=2)

# 4. 加载 val.json 和 val_ans.json
with open(val_json_path, 'r') as f:
    val_data = json.load(f)
with open(val_ans_json_path, 'r') as f:
    val_ans_data = json.load(f)

# 5. 将 val_data 和 val_ans_data 按同一顺序打包成对
paired = list(zip(val_data, val_ans_data))

# 6. 随机打乱配对列表
random.shuffle(paired)

# 7. 解包回各自列表
val_data_shuffled, val_ans_shuffled = zip(*paired)

# 8. 写回 val.json 和 val_ans.json
with open(val_json_path, 'w') as f:
    json.dump(list(val_data_shuffled), f, indent=2)
with open(val_ans_json_path, 'w') as f:
    json.dump(list(val_ans_shuffled), f, indent=2)

print("Shuffle complete: train.json, val.json, and val_ans.json have been shuffled in sync.")
