import os
import json
import shortuuid

# === Paths ===
VAL_INPUT_JSON = "/fs/scratch/PAS2099/Jiacheng/Orientation/val_v2/val_.json"
VAL_IMAGES_DIR = "/fs/scratch/PAS2099/Jiacheng/Orientation/val_v2/image"
OUTPUT_VAL     = "/fs/scratch/PAS2099/Jiacheng/Orientation/val_v2/val.json"
OUTPUT_VAL_ANS = "/fs/scratch/PAS2099/Jiacheng/Orientation/val_v2/val_ans.json"

# the nine orientation options
OPTIONS = [
    "front",
    "front right",
    "right",
    "back right",
    "back",
    "back left",
    "left",
    "front left",
    "top"
]

# build the numbered choice string once
choice_list = ", ".join(f"{i+1}. {opt}" for i, opt in enumerate(OPTIONS))

# === Load existing val entries ===
with open(VAL_INPUT_JSON, "r") as f:
    val_entries = json.load(f)

val_list     = []
val_ans_list = []

for entry in val_entries:
    # unique question id
    qid = shortuuid.uuid()
    # image filename only
    img_fn = os.path.basename(entry["image"])
    # object name for template
    obj = entry["category_name"]
    # construct the standardized question
    question = (
        f"What is the orientation of the {obj} in the image? "
        f"Choose one from below. {choice_list}"
    )
    answer = entry["label"]

    # record for val.json
    val_list.append({
        "question_id": qid,
        "image": img_fn,
        "category": "default",
        "text": question
    })

    # record for val_ans.json
    val_ans_list.append({
        "question_id": qid,
        "prompt": question,
        "text": answer,
        "answer_id": None,
        "model_id": None,
        "metadata": {}
    })

# ensure output dir exists
os.makedirs(os.path.dirname(OUTPUT_VAL), exist_ok=True)

# save files
with open(OUTPUT_VAL,     "w") as f:
    json.dump(val_list,     f, indent=2, ensure_ascii=False)
with open(OUTPUT_VAL_ANS, "w") as f:
    json.dump(val_ans_list, f, indent=2, ensure_ascii=False)

print(f"✅ Generated {len(val_list)} entries in {OUTPUT_VAL}")
print(f"✅ Generated {len(val_ans_list)} entries in {OUTPUT_VAL_ANS}")
