import os
import json

# === Paths ===
INPUT_JSON  = "/fs/scratch/PAS2099/Jiacheng/Orientation/train_v2/train.json"
OUTPUT_JSON = "/fs/scratch/PAS2099/Jiacheng/Orientation/train_v2/train_updated.json"

# === Load existing train.json ===
with open(INPUT_JSON, "r") as f:
    data = json.load(f)

# === Update each entry's image path ===
for entry in data:
    # get only the filename (e.g. "moRfbVZ7ajbg9VjBqfRLEQ.jpg")
    fname = os.path.basename(entry["image"])
    # construct new relative path
    entry["image"] = os.path.join("Orientation", "train", "image", fname)

# === Save back to a new JSON (or overwrite the old one) ===
with open(OUTPUT_JSON, "w") as f:
    json.dump(data, f, indent=2, ensure_ascii=False)

print(f"✅ Updated image paths written to: {OUTPUT_JSON}")
