#!/usr/bin/env python3
import os
import shutil

# 原始路径和目标路径
src_root = '/fs/scratch/PAS2099/Jiacheng/AID/data'
dst_root = '/fs/scratch/PAS2099/Jiacheng/AID_original'

# 确保目标目录存在
os.makedirs(dst_root, exist_ok=True)

# 遍历所有子文件夹
for folder_name in os.listdir(src_root):
    src_path = os.path.join(src_root, folder_name)
    if not os.path.isdir(src_path):
        continue

    # 去掉 “remote sensing ” 前缀
    if folder_name.startswith('remote sensing '):
        new_name = folder_name[len('remote sensing '):]
    else:
        new_name = folder_name

    dst_path = os.path.join(dst_root, new_name)
    # 复制整个文件夹到新位置并改名
    shutil.copytree(src_path, dst_path)
    print(f'Copied "{folder_name}" → "{new_name}"')

print("✅ All folders have been copied and renamed.")
