import os

# Define the path to the directory containing label folders
data_dir = "/fs/scratch/PAS2099/Jiacheng/AID/data"

# List all entries in data_dir and filter to only include directories
folders = [
    name for name in os.listdir(data_dir)
    if os.path.isdir(os.path.join(data_dir, name))
]

for folder in folders:
    old_path = os.path.join(data_dir, folder)
    # Prefix "remote sensing " to the original folder name
    new_name = f"remote sensing {folder}"
    new_path = os.path.join(data_dir, new_name)
    # Rename the folder
    os.rename(old_path, new_path)

print("Finished renaming all label folders.")
