import csv
import os

# 输入、输出路径
input_csv = '/fs/scratch/PAS2099/Jiacheng/Places_merge/output/llm_optimized_scene_labels_v2.csv'
output_csv = '/fs/scratch/PAS2099/Jiacheng/Places_merge/output/fine_grained.csv'

# 确保输出目录存在
os.makedirs(os.path.dirname(output_csv), exist_ok=True)

with open(input_csv, newline='', encoding='utf-8') as fin, \
     open(output_csv, 'w', newline='', encoding='utf-8') as fout:

    reader = csv.DictReader(fin)
    # 保持原有表头：original_label, optimized_label
    writer = csv.DictWriter(fout, fieldnames=reader.fieldnames)
    writer.writeheader()

    for row in reader:
        # original_label 形如 "/c/covered_bridge/exterior"
        path = row['original_label'].strip('/')
        parts = path.split('/')
        # 跳过形如 "/c/xxx"（len(parts)==2），只保留 len(parts)>=3 的“细粒度”标签
        if len(parts) >= 3:
            writer.writerow(row)

print(f"Done. Fine-grained entries written to: {output_csv}")
