import os
import csv

# 输入／输出路径
input_csv  = '/fs/scratch/PAS2099/Jiacheng/Places_merge/output/fine_grained.csv'
output_csv = '/fs/scratch/PAS2099/Jiacheng/Places_merge/output/fine_grained_edge_v2.csv'

os.makedirs(os.path.dirname(output_csv), exist_ok=True)

with open(input_csv, newline='', encoding='utf-8') as fin, \
     open(output_csv, 'w', newline='', encoding='utf-8') as fout:

    reader = csv.reader(fin)
    writer = csv.writer(fout)

    # 读取并写入表头
    header = next(reader)
    writer.writerow(header)

    for original_label, optimized_label in reader:
        # 只考虑细粒度（路径层级 > 2）
        parts = original_label.lstrip('/').split('/')
        if len(parts) <= 2:
            continue

        # 基于“倒序 + 去下划线”生成的硬编码标签
        rule_label = " ".join(
            p.replace('_', ' ')
            for p in reversed(parts[1:])
        ).lower()

        # 如果优化标签与硬编码结果不同，则提取
        if optimized_label.strip().lower() != rule_label:
            writer.writerow([original_label, optimized_label])

print(f"Done. Extracted edge-case fine-grained entries to: {output_csv}")
