import re, csv, pathlib
# ---------- 填入你那份原始列表 ---------- #
raw = """<
/a/airfield 0
/a/airplane_cabin 1
/a/airport_terminal 2
/a/alcove 3
/a/alley 4
/a/amphitheater 5
/a/amusement_arcade 6
/a/amusement_park 7
/a/apartment_building/outdoor 8
/a/aquarium 9
/a/aqueduct 10
/a/arcade 11
/a/arch 12
/a/archaelogical_excavation 13
/a/archive 14
/a/arena/hockey 15
/a/arena/performance 16
/a/arena/rodeo 17
/a/army_base 18
/a/art_gallery 19
/a/art_school 20
/a/art_studio 21
/a/artists_loft 22
/a/assembly_line 23
/a/athletic_field/outdoor 24
/a/atrium/public 25
/a/attic 26
/a/auditorium 27
/a/auto_factory 28
/a/auto_showroom 29
/b/badlands 30
/b/bakery/shop 31
/b/balcony/exterior 32
/b/balcony/interior 33
/b/ball_pit 34
/b/ballroom 35
/b/bamboo_forest 36
/b/bank_vault 37
/b/banquet_hall 38
/b/bar 39
/b/barn 40
/b/barndoor 41
/b/baseball_field 42
/b/basement 43
/b/basketball_court/indoor 44
/b/bathroom 45
/b/bazaar/indoor 46
/b/bazaar/outdoor 47
/b/beach 48
/b/beach_house 49
/b/beauty_salon 50
/b/bedchamber 51
/b/bedroom 52
/b/beer_garden 53
/b/beer_hall 54
/b/berth 55
/b/biology_laboratory 56
/b/boardwalk 57
/b/boat_deck 58
/b/boathouse 59
/b/bookstore 60
/b/booth/indoor 61
/b/botanical_garden 62
/b/bow_window/indoor 63
/b/bowling_alley 64
/b/boxing_ring 65
/b/bridge 66
/b/building_facade 67
/b/bullring 68
/b/burial_chamber 69
/b/bus_interior 70
/b/bus_station/indoor 71
/b/butchers_shop 72
/b/butte 73
/c/cabin/outdoor 74
/c/cafeteria 75
/c/campsite 76
/c/campus 77
/c/canal/natural 78
/c/canal/urban 79
/c/candy_store 80
/c/canyon 81
/c/car_interior 82
/c/carrousel 83
/c/castle 84
/c/catacomb 85
/c/cemetery 86
/c/chalet 87
/c/chemistry_lab 88
/c/childs_room 89
/c/church/indoor 90
/c/church/outdoor 91
/c/classroom 92
/c/clean_room 93
/c/cliff 94
/c/closet 95
/c/clothing_store 96
/c/coast 97
/c/cockpit 98
/c/coffee_shop 99
/c/computer_room 100
/c/conference_center 101
/c/conference_room 102
/c/construction_site 103
/c/corn_field 104
/c/corral 105
/c/corridor 106
/c/cottage 107
/c/courthouse 108
/c/courtyard 109
/c/creek 110
/c/crevasse 111
/c/crosswalk 112
/d/dam 113
/d/delicatessen 114
/d/department_store 115
/d/desert/sand 116
/d/desert/vegetation 117
/d/desert_road 118
/d/diner/outdoor 119
/d/dining_hall 120
/d/dining_room 121
/d/discotheque 122
/d/doorway/outdoor 123
/d/dorm_room 124
/d/downtown 125
/d/dressing_room 126
/d/driveway 127
/d/drugstore 128
/e/elevator/door 129
/e/elevator_lobby 130
/e/elevator_shaft 131
/e/embassy 132
/e/engine_room 133
/e/entrance_hall 134
/e/escalator/indoor 135
/e/excavation 136
/f/fabric_store 137
/f/farm 138
/f/fastfood_restaurant 139
/f/field/cultivated 140
/f/field/wild 141
/f/field_road 142
/f/fire_escape 143
/f/fire_station 144
/f/fishpond 145
/f/flea_market/indoor 146
/f/florist_shop/indoor 147
/f/food_court 148
/f/football_field 149
/f/forest/broadleaf 150
/f/forest_path 151
/f/forest_road 152
/f/formal_garden 153
/f/fountain 154
/g/galley 155
/g/garage/indoor 156
/g/garage/outdoor 157
/g/gas_station 158
/g/gazebo/exterior 159
/g/general_store/indoor 160
/g/general_store/outdoor 161
/g/gift_shop 162
/g/glacier 163
/g/golf_course 164
/g/greenhouse/indoor 165
/g/greenhouse/outdoor 166
/g/grotto 167
/g/gymnasium/indoor 168
/h/hangar/indoor 169
/h/hangar/outdoor 170
/h/harbor 171
/h/hardware_store 172
/h/hayfield 173
/h/heliport 174
/h/highway 175
/h/home_office 176
/h/home_theater 177
/h/hospital 178
/h/hospital_room 179
/h/hot_spring 180
/h/hotel/outdoor 181
/h/hotel_room 182
/h/house 183
/h/hunting_lodge/outdoor 184
/i/ice_cream_parlor 185
/i/ice_floe 186
/i/ice_shelf 187
/i/ice_skating_rink/indoor 188
/i/ice_skating_rink/outdoor 189
/i/iceberg 190
/i/igloo 191
/i/industrial_area 192
/i/inn/outdoor 193
/i/islet 194
/j/jacuzzi/indoor 195
/j/jail_cell 196
/j/japanese_garden 197
/j/jewelry_shop 198
/j/junkyard 199
/k/kasbah 200
/k/kennel/outdoor 201
/k/kindergarden_classroom 202
/k/kitchen 203
/l/lagoon 204
/l/lake/natural 205
/l/landfill 206
/l/landing_deck 207
/l/laundromat 208
/l/lawn 209
/l/lecture_room 210
/l/legislative_chamber 211
/l/library/indoor 212
/l/library/outdoor 213
/l/lighthouse 214
/l/living_room 215
/l/loading_dock 216
/l/lobby 217
/l/lock_chamber 218
/l/locker_room 219
/m/mansion 220
/m/manufactured_home 221
/m/market/indoor 222
/m/market/outdoor 223
/m/marsh 224
/m/martial_arts_gym 225
/m/mausoleum 226
/m/medina 227
/m/mezzanine 228
/m/moat/water 229
/m/mosque/outdoor 230
/m/motel 231
/m/mountain 232
/m/mountain_path 233
/m/mountain_snowy 234
/m/movie_theater/indoor 235
/m/museum/indoor 236
/m/museum/outdoor 237
/m/music_studio 238
/n/natural_history_museum 239
/n/nursery 240
/n/nursing_home 241
/o/oast_house 242
/o/ocean 243
/o/office 244
/o/office_building 245
/o/office_cubicles 246
/o/oilrig 247
/o/operating_room 248
/o/orchard 249
/o/orchestra_pit 250
/p/pagoda 251
/p/palace 252
/p/pantry 253
/p/park 254
/p/parking_garage/indoor 255
/p/parking_garage/outdoor 256
/p/parking_lot 257
/p/pasture 258
/p/patio 259
/p/pavilion 260
/p/pet_shop 261
/p/pharmacy 262
/p/phone_booth 263
/p/physics_laboratory 264
/p/picnic_area 265
/p/pier 266
/p/pizzeria 267
/p/playground 268
/p/playroom 269
/p/plaza 270
/p/pond 271
/p/porch 272
/p/promenade 273
/p/pub/indoor 274
/r/racecourse 275
/r/raceway 276
/r/raft 277
/r/railroad_track 278
/r/rainforest 279
/r/reception 280
/r/recreation_room 281
/r/repair_shop 282
/r/residential_neighborhood 283
/r/restaurant 284
/r/restaurant_kitchen 285
/r/restaurant_patio 286
/r/rice_paddy 287
/r/river 288
/r/rock_arch 289
/r/roof_garden 290
/r/rope_bridge 291
/r/ruin 292
/r/runway 293
/s/sandbox 294
/s/sauna 295
/s/schoolhouse 296
/s/science_museum 297
/s/server_room 298
/s/shed 299
/s/shoe_shop 300
/s/shopfront 301
/s/shopping_mall/indoor 302
/s/shower 303
/s/ski_resort 304
/s/ski_slope 305
/s/sky 306
/s/skyscraper 307
/s/slum 308
/s/snowfield 309
/s/soccer_field 310
/s/stable 311
/s/stadium/baseball 312
/s/stadium/football 313
/s/stadium/soccer 314
/s/stage/indoor 315
/s/stage/outdoor 316
/s/staircase 317
/s/storage_room 318
/s/street 319
/s/subway_station/platform 320
/s/supermarket 321
/s/sushi_bar 322
/s/swamp 323
/s/swimming_hole 324
/s/swimming_pool/indoor 325
/s/swimming_pool/outdoor 326
/s/synagogue/outdoor 327
/t/television_room 328
/t/television_studio 329
/t/temple/asia 330
/t/throne_room 331
/t/ticket_booth 332
/t/topiary_garden 333
/t/tower 334
/t/toyshop 335
/t/train_interior 336
/t/train_station/platform 337
/t/tree_farm 338
/t/tree_house 339
/t/trench 340
/t/tundra 341
/u/underwater/ocean_deep 342
/u/utility_room 343
/v/valley 344
/v/vegetable_garden 345
/v/veterinarians_office 346
/v/viaduct 347
/v/village 348
/v/vineyard 349
/v/volcano 350
/v/volleyball_court/outdoor 351
/w/waiting_room 352
/w/water_park 353
/w/water_tower 354
/w/waterfall 355
/w/watering_hole 356
/w/wave 357
/w/wet_bar 358
/w/wheat_field 359
/w/wind_farm 360
/w/windmill 361
/y/yard 362
/y/youth_hostel 363
/z/zen_garden 364
/t/toll_plaza 0
/b/baggage_claim 1
/d/dentists_office 2
/l/lido_deck/outdoor 3
/h/hot_tub/outdoor 4
/d/dining_car 5
/v/videostore 6
/c/cheese_factory 7
/c/courtroom 8
/e/elevator/interior 9
/g/great_hall 10
/t/teashop 11
/l/labyrinth/outdoor 12
/r/ranch_house 13
/p/promenade_deck 14
/w/warehouse/indoor 15
/v/volleyball_court/indoor 16
/m/music_store 17
/l/limousine_interior 18
/w/wine_cellar/barrel_storage 19
/t/tennis_court/outdoor 20
/f/firing_range/indoor 21
/t/tennis_court/indoor 22
/c/casino/indoor 23
/s/subway_interior 24
/w/wine_cellar/bottle_storage 25
/b/badminton_court/indoor 26
/o/optician 27
/b/basketball_court/outdoor 28
/s/squash_court 29
/h/hat_shop 30
/a/athletic_field/indoor 31
/c/cybercafe 32
/l/loft 33
/e/electrical_substation 34
/t/thriftshop 35
/f/factory/indoor 36
/s/shower_room 37
/b/bow_window/outdoor 38
/n/nuclear_power_plant/outdoor 39
/a/anechoic_chamber 40
/b/batters_box 41
/c/chicken_coop/outdoor 42
/h/hot_tub/indoor 43
/e/editing_room 44
/o/observatory/outdoor 45
/d/dinette/vehicle 46
/r/rest_area 47
/p/portrait_studio 48
/c/covered_bridge/exterior 49
/f/funeral_home 50
/k/kennel/indoor 51
/p/power_plant/outdoor 52
/w/walk_in_freezer 53
/o/oil_refinery/outdoor 54
/f/forest/needleleaf 55
/f/florist_shop/outdoor 56
/l/liquor_store/outdoor 57
/j/jail/indoor 58
/p/poolroom/home 59
/d/driving_range/outdoor 60
/b/brewery/indoor 61
/o/outhouse/outdoor 62
/p/podium/indoor 63
/t/theater/indoor_seats 64
/f/fitting_room/interior 65
/a/aquatic_theater 66
/p/podium/outdoor 67
/s/synagogue/indoor 68>"""
# ---------------------------------------- #

# 25 处人工润色对照表
manual = {
    "exterior balcony": "outdoor balcony",
    "interior balcony": "indoor balcony",
    "exterior gazebo": "gazebo exterior",
    "exterior covered bridge": "covered bridge exterior",
    "interior elevator": "elevator interior",
    "vehicle dinette": "dinette car",
    "interior fitting room": "fitting room",
    "walk in freezer": "walk‑in freezer",
    "barrel storage wine cellar": "wine cellar with barrels",
    "bottle storage wine cellar": "wine cellar with bottles",
    "asia temple": "Asian temple",
    "indoor factory": "factory interior",
    "indoor warehouse": "warehouse interior",
    "indoor brewery": "brewery interior",
    "indoor jail": "jail interior",
    "indoor parking garage": "parking garage interior",
    "outdoor parking garage": "parking garage exterior",
    "indoor greenhouse": "greenhouse interior",
    "outdoor greenhouse": "greenhouse exterior",
    "indoor library": "library interior",
    "outdoor library": "library exterior",
    "indoor general store": "general store interior",
    "outdoor general store": "general store exterior",
    "indoor hangar": "hangar interior",
    "outdoor hangar": "hangar exterior"
}

def to_natural(path: str) -> str:
    core = path.lstrip('/').split()[0]          # 去掉前导 / 与编号
    parts = core.split('/')                     # 分段
    parts = parts[1:]                           # 去掉类别字母
    parts = [p.replace('_', ' ') for p in parts]
    label = ' '.join(reversed(parts)).lower()   # 逆序重排
    label = re.sub(r'\s+', ' ', label).strip()
    return manual.get(label, label)             # 润色

rows = []
for line in raw.strip().splitlines():
    path = line.split()[0]        # "/a/airfield"
    rows.append((path, to_natural(path)))

csv_path = pathlib.Path('/fs/scratch/PAS2099/Jiacheng/Places_merge/output/scene_labels.csv')
with csv_path.open('w', newline='', encoding='utf-8') as f:
    writer = csv.writer(f)
    writer.writerow(['original_label', 'optimized_label'])
    writer.writerows(rows)

print(f'✅ CSV saved to {csv_path.resolve()} with {len(rows)} rows')
