#!/usr/bin/env python3
import os
import shutil

src_root = '/fs/scratch/PAS2099/Jiacheng/AID_original'
dst_root = '/fs/scratch/PAS2099/Jiacheng/Places_merge/output/merged_optimized_data_v5'

# 方法一：手动遍历每个子文件夹、逐文件复制
for label in os.listdir(src_root):
    src_label_dir = os.path.join(src_root, label)
    if not os.path.isdir(src_label_dir):
        continue
    dst_label_dir = os.path.join(dst_root, label)
    os.makedirs(dst_label_dir, exist_ok=True)
    for fname in os.listdir(src_label_dir):
        src_file = os.path.join(src_label_dir, fname)
        if os.path.isfile(src_file):
            shutil.copy2(src_file, dst_label_dir)
    print(f'Copied {label} → {dst_label_dir}')