import os
import json
import shutil

# — Configuration —
VAL_IMG_DIR    = "/fs/scratch/PAS2099/Jiacheng/place365/data/val_large"
JSON_FILE      = "/fs/scratch/PAS2099/Jiacheng/place365/output/places365_val_data.json"
OUTPUT_ROOT    = "/fs/scratch/PAS2099/Jiacheng/place365/output/data_with_category"
# — End Configuration —

def main():
    # 1. Load JSON mapping image_name → label
    with open(JSON_FILE, "r") as f:
        records = json.load(f)
    name2label = {rec["image_name"]: rec["label"] for rec in records}

    # 2. Iterate over all files in val_large
    for fname in os.listdir(VAL_IMG_DIR):
        if fname not in name2label:
            # skip files not in JSON
            continue

        label = name2label[fname]                  # e.g. "greenhouse/indoor" or "wet_bar"
        src_path = os.path.join(VAL_IMG_DIR, fname)
        dst_dir  = os.path.join(OUTPUT_ROOT, label)
        dst_path = os.path.join(dst_dir, fname)

        # Create category directory if needed
        os.makedirs(dst_dir, exist_ok=True)
        # Copy the image
        shutil.copy2(src_path, dst_path)

    print("✅ Finished organizing validation images into categories.")

if __name__ == "__main__":
    main()
