import json
import os

# — Configuration —
INPUT_JSON = "/fs/scratch/PAS2099/Jiacheng/place365/output/places365_val_finegrained.json"
OUTPUT_TXT = "/fs/scratch/PAS2099/Jiacheng/place365/output/fine_grained_label_name.txt"
# — End Configuration —

def main():
    # 1. Load the fine-grained JSON
    with open(INPUT_JSON, "r") as f:
        data = json.load(f)

    # 2. Extract all labels (deduplicated)
    labels = {entry["label"] for entry in data if "label" in entry}

    # 3. Write sorted labels to the output file
    os.makedirs(os.path.dirname(OUTPUT_TXT), exist_ok=True)
    with open(OUTPUT_TXT, "w") as out:
        for label in sorted(labels):
            out.write(label + "\n")

    print(f"✅ Extracted {len(labels)} unique fine-grained labels to:")
    print(f"   {OUTPUT_TXT}")

if __name__ == "__main__":
    main()
