#%%
# First print out all object labels for LVIS, NYU_Depth and object365
# object 365
import json

# === Load the full JSON ===
with open("../object365/zhiyuan_objv2_val.json", "r") as f:
    full_data = json.load(f)

# === Extract category names ===
categories = full_data["categories"]
category_names = sorted({cat["name"] for cat in categories})  # use set for uniqueness, sorted for order

# === Save to txt file ===
with open("object365_unique_category_labels.txt", "w") as f:
    for name in category_names:
        f.write(name + "\n")

print(f"✅ Saved {len(category_names)} unique category labels to 'unique_category_labels.txt'")

#%%
# NYU_Depth
# Already stored under: /fs/scratch/PAS2099/Lemeng/NYU_depth/nyu_metadata/nyu_class_labels.txt

#%%
# LVIS
import json
import csv
from tqdm import tqdm

# === Load the LVIS JSON file ===
with open("../LVIS/lvis_v1_val.json", "r") as f:
    data = json.load(f)

# === Extract and sort unique category names ===
unique_category_names = sorted({cat["synonyms"][0] for cat in data["categories"]})

# === Save to TXT file ===
with open("lvis_unique_category_labels.txt", "w") as f:
    for name in unique_category_names:
        f.write(name + "\n")

print(f"✅ Saved {len(unique_category_names)} unique LVIS category labels to 'lvis_unique_category_labels.txt'")
