import pandas as pd

# === Paths ===
csv_path = "/fs/scratch/PAS2099/Lemeng/Spatial_combined/third_master_label_mapping_table_corrected.csv"                # Replace with your actual CSV filename
output_txt_path = "third_unique_unified_labels.txt"

# === Load CSV ===
df = pd.read_csv(csv_path)

# === Filter and extract unique unified labels with match_type == "unique"
unique_labels = sorted(set(
    df.loc[df["match_type"] == "unique", "unified_label"].dropna().str.strip()
))

# === Write to text file
with open(output_txt_path, "w", encoding="utf-8") as f:
    f.write(", ".join(unique_labels))


print(f"✅ Saved {len(unique_labels)} unique labels to: {output_txt_path}")
