#%%
import pandas as pd
import matplotlib.pyplot as plt
import matplotlib.patches as patches
from PIL import Image
import ast
import random
import os

# === Config ===
csv_path = "object365_valid_nonoverlapping_pairs.csv"
image_root = "../object365/"
num_to_plot = 5
random.seed(42)

# === Load CSV ===
df = pd.read_csv(csv_path)

# Sample N rows
sampled_rows = df.sample(n=min(num_to_plot, len(df)), random_state=42)

for idx, row in sampled_rows.iterrows():
    image_path = os.path.join(image_root, row["image_path"])
    
    try:
        img = Image.open(image_path).convert("RGB")
    except Exception as e:
        print(f"❌ Could not open image {image_path}: {e}")
        continue

    # Parse stringified lists
    arche_bbox = ast.literal_eval(row["arche_bbox"])
    target_bbox = ast.literal_eval(row["target_bbox"])
    arche_center = ast.literal_eval(row["arche_center"])
    target_center = ast.literal_eval(row["target_center"])

    # Plotting
    fig, ax = plt.subplots(1, figsize=(8, 6))
    ax.imshow(img)

    # Draw arche bbox in red
    rect_arche = patches.Rectangle(
        (arche_bbox[0], arche_bbox[1]), arche_bbox[2], arche_bbox[3],
        linewidth=2, edgecolor="red", facecolor='none')
    ax.add_patch(rect_arche)
    ax.text(arche_bbox[0], arche_bbox[1] - 5, f"Arche: {row['arche_object']}",
            color="red", fontsize=12, weight="bold")

    # Draw target bbox in blue
    rect_target = patches.Rectangle(
        (target_bbox[0], target_bbox[1]), target_bbox[2], target_bbox[3],
        linewidth=2, edgecolor="blue", facecolor='none')
    ax.add_patch(rect_target)
    ax.text(target_bbox[0], target_bbox[1] - 5, f"Target: {row['target_object']}",
            color="blue", fontsize=12, weight="bold")

    # Show spatial relation
    ax.set_title(f"📍 Spatial: {row['spatial_answer']} | 🖼 {image_path}")
    ax.axis("off")
    plt.tight_layout()
    plt.show()

# %%
