import pandas as pd

# Path to your CSV file
csv_path = "/fs/scratch/PAS2099/Lemeng/Spatial_combined/ran50_balanced_target_samples.csv"

# Load CSV
df = pd.read_csv(csv_path)

# Get unique values in 'target_object' column
unique_targets = df["target_object"].unique()

# Save to TXT file
with open("unique_target_objects.txt", "w", encoding="utf-8") as f:
    for item in unique_targets:
        f.write(f"{item}\n")

print(f"Saved {len(unique_targets)} unique target_object values to unique_target_objects.txt")
