#%%
import os
import matplotlib.pyplot as plt

# Path to the UIUC attribute root directory
root_dir = '/fs/scratch/PAS2099/Jiacheng/Texture_tmp/UIUC'

# Supported image extensions
valid_exts = {'.png', '.jpg', '.jpeg', '.bmp', '.tiff'}

# Dictionary to hold image counts per attribute
attribute_counts = {}

# Traverse each attribute folder
for attribute in os.listdir(root_dir):
    attr_path = os.path.join(root_dir, attribute)
    if not os.path.isdir(attr_path):
        continue
    # Count valid images in this attribute folder
    count = 0
    for fname in os.listdir(attr_path):
        if os.path.splitext(fname)[1].lower() in valid_exts:
            count += 1
    attribute_counts[attribute] = count

# 1. Number of total attributes
total_attributes = len(attribute_counts)
# 2. Number of total images
total_images = sum(attribute_counts.values())

# 3. Print attribute: number of images
print(f"1. Number of total attributes: {total_attributes}")
print(f"2. Number of total images: {total_images}")
print("3. Attribute: number of images")
for attr, cnt in sorted(attribute_counts.items()):
    print(f"   {attr}: {cnt}")

# Plot histogram (bar chart) of attribute vs. image count
plt.figure(figsize=(12, 6))
plt.bar(attribute_counts.keys(), attribute_counts.values())
plt.xticks(rotation=45, ha='right')
plt.xlabel('Attribute (Class)')
plt.ylabel('Number of Images')
plt.title('UIUC Texture: Images per Attribute')
plt.tight_layout()
plt.show()

# %%
