import os

# Paths
merged_dir = '/fs/scratch/PAS2099/Jiacheng/Texture_tmp/merged_dataset'
dtd_dir    = '/fs/scratch/PAS2099/Jiacheng/Texture_tmp/Textual_dtd/images'
output_txt = '/fs/scratch/PAS2099/Jiacheng/Texture_tmp/output/attribute_name.txt'

# 1. Gather all attribute folder names in merged_dataset
merged_attrs = {
    name for name in os.listdir(merged_dir)
    if os.path.isdir(os.path.join(merged_dir, name))
}

# 2. Gather all attribute folder names in Textual_dtd
dtd_attrs = {
    name for name in os.listdir(dtd_dir)
    if os.path.isdir(os.path.join(dtd_dir, name))
}

# 3. Compute difference: attributes in merged_dataset but not in DTD
filtered_attrs = sorted(merged_attrs - dtd_attrs)

# 4. Ensure output directory exists
os.makedirs(os.path.dirname(output_txt), exist_ok=True)

# 5. Write to attribute_name.txt
with open(output_txt, 'w') as f:
    for attr in filtered_attrs:
        f.write(f"{attr}\n")

print(f"Wrote {len(filtered_attrs)} attribute names to {output_txt}")
