import os
import shutil

# 设置路径
src_root = '/fs/scratch/PAS2099/Jiacheng/Texture_tmp/merged_dataset_v3'
dst_root = '/fs/scratch/PAS2099/Jiacheng/Texture_tmp/merged_dataset_v4'

# 创建目标文件夹
os.makedirs(dst_root, exist_ok=True)

# 遍历所有 attribute 文件夹
for attr in os.listdir(src_root):
    src_attr_path = os.path.join(src_root, attr)
    dst_attr_path = os.path.join(dst_root, attr)

    if not os.path.isdir(src_attr_path):
        continue

    # 遍历图像文件
    for fname in os.listdir(src_attr_path):
        if "FMD" in fname:
            continue  # 跳过包含 FMD 的图像

        # 创建目标 attribute 文件夹（若还未创建）
        os.makedirs(dst_attr_path, exist_ok=True)

        # 拷贝文件
        src_file = os.path.join(src_attr_path, fname)
        dst_file = os.path.join(dst_attr_path, fname)
        shutil.copy2(src_file, dst_file)
