#%%
import os
import shutil

# === 大类分组 ===
scene_paths = [
    "/fs/scratch/PAS2099/Jiacheng/place365/code",
    "/fs/scratch/PAS2099/Jiacheng/AID/code",
    "/fs/scratch/PAS2099/Jiacheng/Places_merge/code"
]

texture_paths = [
    "/fs/scratch/PAS2099/Jiacheng/Texture_tmp/code",
    "/fs/scratch/PAS2099/Jiacheng/Texture_tmp/codev2",
    "/fs/scratch/PAS2099/Jiacheng/Texture_tmp/codev3",
    "/fs/scratch/PAS2099/Jiacheng/Texture_tmp/codev4"
]

orientation_paths = [
    "/fs/scratch/PAS2099/Jiacheng/EgoOrientBench/code",
    "/fs/scratch/PAS2099/Jiacheng/EgoOrientBench/codeV2",
    "/fs/scratch/PAS2099/Jiacheng/Cure_or/code",
    "/fs/scratch/PAS2099/Jiacheng/Cure_or/codev2",
    "/fs/scratch/PAS2099/Jiacheng/Orientation/code",
    "/fs/scratch/PAS2099/Jiacheng/Orientation/codev2"
]

category_map = {
    "Scene": scene_paths,
    "Texture": texture_paths,
    "Orientation": orientation_paths
}

base_dir = os.getcwd()

# === 执行复制 ===
for category, paths in category_map.items():
    for src in paths:
        if not os.path.exists(src):
            print(f"[⚠️ Warning] Not found: {src}")
            continue

        project_name = os.path.basename(os.path.dirname(src))  # 如 place365, Cure_or
        subfolder_name = os.path.basename(src)  # 如 code, codev2

        dst = os.path.join(base_dir, category, project_name, subfolder_name)
        os.makedirs(os.path.dirname(dst), exist_ok=True)

        print(f"📂 Copying {src} → {dst}")
        shutil.copytree(src, dst, dirs_exist_ok=True)

print("✅ Done: categorized into Scene, Texture, Orientation.")
