#%%
import os
import requests
from zipfile import ZipFile
from tqdm import tqdm

# List of (url, output filename)
urls = [
    ("http://images.cocodataset.org/zips/val2017.zip", "val2017.zip"),
    ("https://dl.fbaipublicfiles.com/LVIS/lvis_v1_val.json.zip", "lvis_v1_val.json.zip"),
    ("http://images.cocodataset.org/zips/train2017.zip", "train2017.zip"),
    ("https://dl.fbaipublicfiles.com/LVIS/lvis_v1_train.json.zip", "lvis_v1_train.json.zip"),
]

output_dir = "downloads"
os.makedirs(output_dir, exist_ok=True)

def download_file(url, output_path):
    response = requests.get(url, stream=True)
    total = int(response.headers.get('content-length', 0))
    with open(output_path, 'wb') as file, tqdm(
        desc=f"Downloading {os.path.basename(output_path)}",
        total=total,
        unit='B',
        unit_scale=True,
        unit_divisor=1024,
    ) as bar:
        for data in response.iter_content(chunk_size=1024):
            size = file.write(data)
            bar.update(size)

def extract_zip(zip_path, extract_to):
    with ZipFile(zip_path, 'r') as zip_ref:
        zip_ref.extractall(extract_to)
        print(f"✅ Extracted: {zip_path} to {extract_to}")

# Download and extract each file
for url, filename in urls:
    filepath = os.path.join(output_dir, filename)
    if not os.path.exists(filepath):
        download_file(url, filepath)
    else:
        print(f"⏩ Already downloaded: {filename}")
    extract_zip(filepath, output_dir)
