#%%
import os
import requests
import zipfile

# List of URLs to download
urls = [
    "https://s3.amazonaws.com/cvmlp/vqa/mscoco/vqa/v2_Questions_Train_mscoco.zip",
    "https://s3.amazonaws.com/cvmlp/vqa/mscoco/vqa/v2_Questions_Val_mscoco.zip",
    "https://s3.amazonaws.com/cvmlp/vqa/mscoco/vqa/v2_Questions_Test_mscoco.zip",
    "https://s3.amazonaws.com/cvmlp/vqa/mscoco/vqa/v2_Annotations_Train_mscoco.zip",
    "https://s3.amazonaws.com/cvmlp/vqa/mscoco/vqa/v2_Annotations_Val_mscoco.zip",
    "http://images.cocodataset.org/zips/train2014.zip",
    "http://images.cocodataset.org/zips/val2014.zip"

]

# Directory to save downloaded files and extract contents
output_dir = "vqav2_data"
os.makedirs(output_dir, exist_ok=True)

# Function to download and unzip files
def download_and_unzip(url, dest_dir):
    filename = url.split("/")[-1]
    zip_path = os.path.join(dest_dir, filename)
    
    print(f"Downloading {filename}...")
    response = requests.get(url, stream=True)
    with open(zip_path, 'wb') as f:
        for chunk in response.iter_content(chunk_size=8192):
            f.write(chunk)
    
    print(f"Unzipping {filename}...")
    with zipfile.ZipFile(zip_path, 'r') as zip_ref:
        zip_ref.extractall(dest_dir)

    # Optionally delete the zip file after extraction
    os.remove(zip_path)

# Run the downloader
for url in urls:
    download_and_unzip(url, output_dir)

print("All files downloaded and extracted.")
