import json

def read_emotion_counts(json_file_path):
    """
    Reads the compact JSON file and outputs the count of entries for each emotion.

    Args:
        json_file_path (str): Path to the JSON file.

    Returns:
        None
    """
    emotion_counts = {}

    # Read the JSON file line by line (since it may contain multiple JSON objects)
    with open(json_file_path, 'r') as file:
        for line in file:
            data = json.loads(line.strip())  # Load each JSON object
            for emotion, entries in data.items():
                if emotion not in emotion_counts:
                    emotion_counts[emotion] = 0
                emotion_counts[emotion] += len(entries)

    # Output the counts for each emotion
    print("Emotion Counts:")
    for emotion, count in emotion_counts.items():
        print(f"{emotion}: {count}")

if __name__ == "__main__":
    # Path to the JSON file
    json_file_path = "/fs/ess/PAS2099/sooyoung/vfm_dataset/emotion/data/processed_data.json"

    try:
        read_emotion_counts(json_file_path)
    except Exception as e:
        print(f"Error: {e}")