import json

def update_json_answers(train_json_path, val_ans_json_path):
    # Update train.json
    with open(train_json_path, 'r') as f:
        train_data = json.load(f)

    for entry in train_data:
        for conversation in entry["conversations"]:
            if conversation["from"] == "gpt":
                # Update "red" to "1. red" and "blue" to "2. blue"
                if conversation["value"] == "red":
                    conversation["value"] = "1. red"
                elif conversation["value"] == "blue":
                    conversation["value"] = "2. blue"

    with open(train_json_path, 'w') as f:
        json.dump(train_data, f, indent=2)

    print(f"✅ Updated {train_json_path}")

    # Update val_ans.json
    with open(val_ans_json_path, 'r') as f:
        val_ans_data = json.load(f)

    for entry in val_ans_data:
        if entry["text"] == "red":
            entry["text"] = "1. red"
        elif entry["text"] == "blue":
            entry["text"] = "2. blue"

    with open(val_ans_json_path, 'w') as f:
        json.dump(val_ans_data, f, indent=2)

    print(f"✅ Updated {val_ans_json_path}")

# Example usage
train_json_path = "/fs/scratch/PAS2099/vfm/exterior_depth/kitti/relative_depth/train/train.json"
val_ans_json_path = "/fs/scratch/PAS2099/vfm/exterior_depth/kitti/relative_depth/val/val_ans.json"
update_json_answers(train_json_path, val_ans_json_path)