#%%
import requests
import tarfile
import os

url = "https://www.robots.ox.ac.uk/~vgg/data/fgvc-aircraft/archives/fgvc-aircraft-2013b.tar.gz"
filename = "fgvc-aircraft-2013b.tar.gz"

print(f"Downloading {url} ...")
response = requests.get(url, stream=True)
if response.status_code == 200:
    with open(filename, "wb") as f:
        for chunk in response.iter_content(chunk_size=8192):
            f.write(chunk)
    print("Download complete.")
else:
    print(f"Failed to download. Status code: {response.status_code}")
    exit(1)

print("Extracting .tar.gz ...")
with tarfile.open(filename, "r:gz") as tar:
    tar.extractall()
print("Extraction complete.")

os.remove(filename)
print("🗑️Removed archive file:", filename)
