#%%
import gdown
print("gdown is available")
#%%
import os

file_ids = [
    "1ZHbHDM6hYAEGDC_K5eiW0yF_lzVgpuir",
    "11SXPqcESez9qTn4Z5Q3v35K9hRwO_epr",
    "1vOmzwxpBtwbK5o8xSa9u0IdB4H95MBHw",
    "1KoQzqR20qvIXDf1qsXCHGxD003IPmXMw"
]

for fid in file_ids:
    cmd = f"gdown --id {fid}"
    print(f"Running: {cmd}")
    os.system(cmd)

#%%
import zipfile
import os

zip_files = [
    "Annotations.zip",
    # "ImageSets.zip",
    # "JPEGImages-test.zip",
    # "JPEGImages-trainval.zip"
]

def unzip_file(zip_path, extract_dir):
    with zipfile.ZipFile(zip_path, 'r') as zip_ref:
        zip_ref.extractall(extract_dir)
        print(f"✅ Extracted {zip_path} → {extract_dir}")

for zip_name in zip_files:
    if not os.path.exists(zip_name):
        print(f"Not found: {zip_name}")
        continue
    target_dir = zip_name.replace(".zip", "_before")
    os.makedirs(target_dir, exist_ok=True)
    unzip_file(zip_name, target_dir)

#%%
import os
import random
import xml.etree.ElementTree as ET
import matplotlib.pyplot as plt
import matplotlib.patches as patches
from PIL import Image

trainval_image_dir = "JPEGImages-trainval/JPEGImages-trainval"
test_image_dir = "JPEGImages-test/JPEGImages-test"
annotation_dir = "Annotations/Annotations/Horizontal Bounding Boxes"

xml_files = [f for f in os.listdir(annotation_dir) if f.endswith('.xml')]
random.shuffle(xml_files)
selected_files = xml_files[:3]

for xml_file in selected_files:
    tree = ET.parse(os.path.join(annotation_dir, xml_file))
    root = tree.getroot()

    filename = root.find('filename').text
    image_path = os.path.join(trainval_image_dir, filename)

    if not os.path.exists(image_path):
        image_path = os.path.join(test_image_dir, filename)
        if not os.path.exists(image_path):
            print(f"missing: {filename}")
            continue

    image = Image.open(image_path)
    fig, ax = plt.subplots(1)
    ax.imshow(image)

    for obj in root.findall('object'):
        bbox = obj.find("bndbox")
        xmin = int(bbox.find("xmin").text)
        ymin = int(bbox.find("ymin").text)
        xmax = int(bbox.find("xmax").text)
        ymax = int(bbox.find("ymax").text)

        rect = patches.Rectangle((xmin, ymin), xmax - xmin, ymax - ymin,
                                 linewidth=2, edgecolor='red', facecolor='none')
        ax.add_patch(rect)
        ax.text(xmin, ymin - 5, obj.find("name").text,
                fontsize=10, color='red', backgroundcolor='white')

    ax.set_title(filename)
    plt.axis('off')
    plt.show()
