import json

LOG_PATH = 'log.json'


# [RDKit, equiv-trunc, 'adj3', 'kabsch']


def check_list_rmsd(lr):
    profit = min([lr[0] - lr[1], lr[2] - lr[1], lr[3] - lr[1]])
    return profit > 0.1 and lr[1] < 0.3


def profit_rmsd(lr):
    profit = min([lr[0] - lr[1], lr[2] - lr[1], lr[3] - lr[1]])
    return profit


if __name__ == '__main__':
    with open(LOG_PATH) as fp:
        ds = json.load(fp)
    list_no = []
    for d in ds:
        no_ = d['no']
        smiles = d['smiles']
        list_rmsd = d['list_rmsd']
        if check_list_rmsd(list_rmsd):
            list_no.append(no_)
            print(f'{no_} {smiles}: {list_rmsd[0]:.3f}, {list_rmsd[1]:.3f}, {list_rmsd[2]:.3f}, {list_rmsd[3]:.3f}')
    print(list_no)
