DefaultPropertyConfig = {
    'CLASSIFIER_HIDDENS': [],

    'HV_DIM': 128,
    'HE_DIM': 64,
    'HM_DIM': 256,
    'MV_DIM': 128,
    'ME_DIM': 64,
    'MM_DIM': 256,
    'POS_DIM': 3,
    'N_LAYER': 1,
    'N_HOP': 2,
    'N_GLOBAL': 2,
    'MESSAGE_TYPE': 'naive',
    'DROPOUT': 0.0,

    'EPOCH': 300,
    'N_MOL_PER_PACK': 16,
    'N_PACK_PER_BATCH': 8,
    'LR': 1e-4,
    'GAMMA': 0.995,
    'DECAY': 1e-5,
}

QM7PropertyConfig = DefaultPropertyConfig.copy()
QM7PropertyConfig.update({
    'DROPOUT': 0.0,
    'EPOCH': 100,
    'N_MOL_PER_PACK': 32,
    'N_PACK_PER_BATCH': 8,
    'LR': 1e-3,
    'GAMMA': 0.98,
    'DECAY': 1e-4,
})

QM8PropertyConfig = DefaultPropertyConfig.copy()
QM8PropertyConfig.update({
    'DROPOUT': 0.0,
    'EPOCH': 100,
    'N_MOL_PER_PACK': 16,
    'N_PACK_PER_BATCH': 16,
    'LR': 1e-4,
    'GAMMA': 0.98,
    'DECAY': 1e-4,
})

DefaultConformationConfig = {
    'HV_DIM': 128,
    'HE_DIM': 64,
    'POS_DIM': 16,
    'GENERATE_TYPE': 'lstm',
    'DERIVE_TYPE': '',
    'COMPARE_TYPE': 'adj3',
    'COMPARE_MIDDLE': False,
    'FF': False,
    'DROPOUT': 0.0,
    'STEP': 5,
    'TAU': 0.2,

    'EPOCH': 300,
    'TRAIN': 1,
    'N_MOL_PER_PACK': 16,
    'N_PACK_PER_BATCH': 8,
    'LR': 1e-5,
    'GAMMA': 0.995,
    'DECAY': 1e-5,
}

QM7ConformationConfig = DefaultConformationConfig.copy()
QM7ConformationConfig.update({
    'DROPOUT': 0.0,
    'EPOCH': 75,
    'TRAIN': 4,
    'N_MOL_PER_PACK': 16,
    'N_PACK_PER_BATCH': 16,
    'LR': 1e-4,
    'GAMMA': 0.98,
    'DECAY': 1e-4,
})

QM8ConformationConfig = DefaultConformationConfig.copy()
QM8ConformationConfig.update({
    'DROPOUT': 0.0,
    'EPOCH': 30,
    'TRAIN': 5,
    'N_MOL_PER_PACK': 16,
    'N_PACK_PER_BATCH': 10,
    'LR': 3e-5,
    'GAMMA': 0.97,
    'DECAY': 1e-4,
})

QM9ConformationConfig = DefaultConformationConfig.copy()
QM9ConformationConfig.update({
    'DROPOUT': 0.0,
    'EPOCH': 100,
    'TRAIN': 2,
    'N_MOL_PER_PACK': 8,
    'N_PACK_PER_BATCH': 20,
    'LR': 1e-5,
    'GAMMA': 0.95,
    'DECAY': 1e-4,
})

DefaultGeomConformationConfig = {
    'HV_DIM': 128,
    'HE_DIM': 64,
    'POS_DIM': 16,
    'GENERATE_TYPE': 'rdkit',
    'DERIVE_TYPE': 'newton',
    'COMPARE_TYPE': 'adj3',
    'COMPARE_MIDDLE': False,
    'FF': False,
    'INCLUDE_RDKIT': False,
    'DROPOUT': 0.0,
    'STEP': 5,
    'TAU': 0.2,

    'EPOCH': 300,
    'TRAIN': 1,
    'N_MOL_PER_PACK': 16,
    'N_PACK_PER_BATCH': 8,
    'LR': 1e-5,
    'GAMMA': 0.98,
    'DECAY': 1e-4,
}

GeomQM9SmallConformationConfig = DefaultGeomConformationConfig.copy()
GeomQM9SmallConformationConfig.update({
    'DROPOUT': 0.0,
    'EPOCH': 10,
    'TRAIN': 10,
    'N_MOL_PER_PACK': 8,
    'N_PACK_PER_BATCH': 20,
    'LR': 1e-3,
    'GAMMA': 0.95,
    'DECAY': 1e-4,
})

GeomQM9ConformationConfig = DefaultGeomConformationConfig.copy()
GeomQM9ConformationConfig.update({
    'DROPOUT': 0.0,
    'EPOCH': 10,
    'TRAIN': 10,
    'N_MOL_PER_PACK': 8,
    'N_PACK_PER_BATCH': 20,
    'LR': 5e-4,
    'GAMMA': 0.90,
    'DECAY': 1e-4,
})

GeomDRUGSmallConformationConfig = DefaultGeomConformationConfig.copy()
GeomDRUGSmallConformationConfig.update({
    'DROPOUT': 0.0,
    'EPOCH': 25,
    'TRAIN': 4,
    'N_MOL_PER_PACK': 4,
    'N_PACK_PER_BATCH': 10,
    'LR': 1e-3,
    'GAMMA': 0.95,
    'DECAY': 1e-4,
})

GeomDRUGConformationConfig = DefaultGeomConformationConfig.copy()
GeomDRUGConformationConfig.update({
    'DROPOUT': 0.0,
    'EPOCH': 10,
    'TRAIN': 10,
    'N_MOL_PER_PACK': 4,
    'N_PACK_PER_BATCH': 10,
    'LR': 1e-4,
    'GAMMA': 0.95,
    'DECAY': 1e-4,
})

ForceConfig = {
    'EPOCH': 30,
    'TRAIN': 10,
    'N_MOL_PER_PACK': 8,
    'N_PACK_PER_BATCH': 20,
    'LR': 1e-5,
    'GAMMA': 0.95,
    'DECAY': 1e-5,
}
