# SEPNet: Semantic-Enhanced Prototypical Network for Universal New Category Discovery

### Task Scenarios
![image](./assets/introduction.png)

### Overview of SEPNet
![image](./assets/Semantic%20Prototypical%20Guidance.png)

## Contents
[1. requirements](#requirements)

[2. Running](#running)

[3. Results](#results)


## <a name="updates"/> Requirements

### Environments

```
scikit_learn==1.3.0
torch==2.0.1+cu118
tqdm==4.65.0
torchvision==0.15.2+cu118
numpy==1.24.1
tensorboard==2.10.0
fast-pytorch-kmeans==0.2.0.1
statistics==1.0.3.5
```

Using requirements.txt:
```bash
conda create --name SEPNet python==3.9.0
conda activate SEPNet
pip install -r requirements.txt
```

### Pretrained Model
The pretrained model used in this work can be found at [ViT-dino](https://huggingface.co/facebook/dino-vits16).

### Datasets

We use generic object recognition datasets, including:

* [CIFAR-10/100](https://pytorch.org/vision/stable/datasets.html)
* [ImageNet](https://image-net.org/download.php)

## <a name="running"/> Running

### Config

Set paths to datasets, pre-trained models and desired log directories in ```config/defaults.py``` , ```configs/pretraina.yml``` and ```configs/unincd.yml```.

Set ```SAVE_DIR``` (logfile destination), ```OUTPUT_DIR``` (path to save pretrained models or checkpoints) and ```MODEL.PRETRAIN_PATH``` (path to the model) in ```scripts``` scripts.


### Scripts

**Pretraining**:

```
bash ./scripts/pretrain/cifar10.sh
bash ./scripts/pretrain/cifar100.sh
bash ./scripts/pretrain/imagenet100.sh
```

**Fit UNINCD task**:
```
bash ./scripts/unincd/cifar10_cl.sh
bash ./scripts/unincd/cifar100_cl.sh
bash ./scripts/unincd/imagenet100_cl.sh
```


## <a name="results"/> Results

Results from re-running models with this repo compared to reported numbers:

| **Dataset**       | **All** | **Known** | **Novel** |
|---------------|------------|---------------|-----------|
| CIFAR10  | 91.18| 91.47 | 90.04 |
| CIFAR100  | 67.05 | 71.57 | 48.97 |
| IMAGENET100  | 86.51 | 87.40 | 82.98 |

