#!/bin/bash
export TF_ENABLE_ONEDNN_OPTS=0
export CUDA_VISIBLE_DEVICES=0

# Get unique log file,
DATASET='Cifar100'
DATE=$(date +"%Y-%m-%d")
SAVE_DIR=./logs/dev_outputs/${DATE}/${DATASET}/PRETRAIN/

if [ ! -d "$SAVE_DIR" ]; then
    mkdir -p "$SAVE_DIR"
    echo "Folder '$SAVE_DIR' created."
else
    echo "Folder '$SAVE_DIR' already exists."
fi

EXP_NUM=$(ls ${SAVE_DIR} | wc -l)
EXP_NUM=$((${EXP_NUM}+1))
echo $EXP_NUM

workdir='/workspace'
pretrain_path=$workdir'/pretrained'
pretrain_model='dino/dino_vitbase16_pretrain.pth'
# pretrain_path='../logs/pretrain/dino/'$DATASET'/metric_learn_gcd/log'
# pretrain_model='26-08_17-36_Cifar10/checkpoints/model_best.pt'
# proj_name='26-08_17-36_Cifar10/checkpoints/model_proj_head_best.pt'
model='dino'

grad_block=10
epoch=200

python3 -m processor.pretrain    \
    --grad_from_block $grad_block \
    --contrast_unlabel_only 'False' \
    --transform 'imagenet' \
    --eval_funcs 'v1' 'v2' \
    --config_file configs/pretrain.yml \
    MODEL.NAME $model \
    DATASETS.NAMES $DATASET \
    DATASETS.CIFAR_100_ROOT $workdir'/dataset/Cifar'\
    DATASETS.PROP_TRAIN_LABELS '0.5' \
    DATALOADER.NUM_WORKERS '12' \
    MODEL.PRETRAIN_PATH $pretrain_path'/'$pretrain_model \
    MODEL.UNINCD_STAGE 'pretrain_MASK' \
    MODEL.PROTO_NUM '10' \
    SOLVER.IMS_PER_BATCH '64' \
    SOLVER.MAX_EPOCHS $epoch \
    TEST.IMS_PER_BATCH '64' \
    OUTPUT_DIR '../logs/pretrain/'$model'/'$DATASET  \
> ${SAVE_DIR}logfile_${EXP_NUM}-grad_${grad_block}-epoch_${epoch}.out