#!/bin/bash
export TF_ENABLE_ONEDNN_OPTS=0
export CUDA_VISIBLE_DEVICES=0

# Get unique log file,
DATASET='Cifar10'
DATE=$(date +"%Y-%m-%d")
SAVE_DIR=./logs/dev_outputs/${DATE}/${DATASET}/UNINCD/

if [ ! -d "$SAVE_DIR" ]; then
    mkdir -p "$SAVE_DIR"
    echo "Folder '$SAVE_DIR' created."
else
    echo "Folder '$SAVE_DIR' already exists."
fi

EXP_NUM=$(ls ${SAVE_DIR} | wc -l)
EXP_NUM=$((${EXP_NUM}+1))
echo $EXP_NUM

workdir='/slurm-files/user'
pretrain_path='../logs/pretrain/dino/ImageNet100/metric_learn_gcd/log/'
pretrain_model='26-08_21-12_ImageNet100/checkpoints/model.pt'
proj_name='26-08_21-12_ImageNet100/checkpoints/model_proj_head.pt'
model='dino'

llw=5.0
uupm=3
upm=5
fm=0.95
uce=0.2
pro=0.3
se=0.8
eur_w=1.5
pool_size=4

python3 -m processor.PARSE \
    --grad_from_block 12 \
    --grad_head_layer 'last_layer' \
    --contrast_unlabel_only 'False' \
    --transform 'imagenet' \
    --eval_funcs 'v1' 'v2' \
    --config_file configs/unincd.yml \
    MODEL.NAME $model \
    MODEL.PRETRAIN_PATH $pretrain_path'/'$pretrain_model \
    MODEL.UNINCD_STAGE 'UNINCD' \
    MODEL.PROTO_NUM '10' \
    MODEL.PROTO_MOMEN '0.' \
    MODEL.PROTO_THRES '0.75' \
    MODEL.FEAT_MOMEN $fm \
    MODEL.ALL_PATCHES 'True' \
    MODEL.POOL_SIZE $pool_size \
    DATASETS.NAMES $DATASET \
    DATASETS.CIFAR_10_ROOT $workdir'/dataset/Cifar'\
    DATASETS.PROP_TRAIN_LABELS '0.5' \
    DATALOADER.NUM_WORKERS '8' \
    SOLVER.UPDATE_MAX $upm \
    SOLVER.UPDATE_UP_MAX $uupm \
    SOLVER.IMS_PER_BATCH '500' \
    SOLVER.MAX_EPOCHS '100' \
    SOLVER.SEED '42' \
    LOSS.W_PRO_L $llw \
    LOSS.W_UCE $uce \
    LOSS.W_PRO $pro \
    LOSS.W_SE $se \
    LOSS.SDR 'True' \
    LOSS.SDR_KL_W $eur_w \
    TEST.IMS_PER_BATCH '100' \
    OUTPUT_DIR '../logs/unincd/'$model'/Cifar10'  \
> ${SAVE_DIR}logfile_${EXP_NUM}-eur_${eur_w}.out
