## Referential Games with Straight-Through Gumbel-Softmax Estimator

This directory contains code and experiments that study the impact of parameterizing the communication channel of a referential game using the Straight-Through Gumbel-Softmax estimator.
It contains code for the following paper:

> [On (Emergent) Systematic Generalisation and Compositionality in Visual Referential Games with Straight-Through Gumbel-Softmax Estimator](https://drive.google.com/file/d/1p6rgNcvtug7UuVHrEgDIZNI6nYILkqZR/view?usp=sharing)
> Kevin Denamganaï and James Alfred Walker.
> [4th NeurIPS Workshop on Emergent Communication: "Talking with Strangers: Zero-Shot Emergent Communication", 2020](https://sites.google.com/view/emecom2020).

Here is a [summary video](https://drive.google.com/file/d/1vdZPqErT3qLlaGUYwJ5iIYdqg3tFLaM3/view?usp=sharing).

### How to run experiments?

Every experiments rely on a set of scripts found in the `scripts` directory, which contains `symoblic` --for experiments with symbolic stimuli-- and `visual` --with visual stimuli-- directories.
Each script describes its expected arguments (and default values), and the relevant sections of the paper and appendices should be enough to diffuse any doubts.
