
import json
import numpy as np
import pickle
from scipy.special import expit as sigmoid

def load_standard(name, data_dir, out_features, base_dir = './Outputs', model = 'initial-tune', trial = 0, fold = 'train'):
    # Get the index for this class
    with open('{}/maps.json'.format(data_dir), 'r') as f:
        name2index, _ = json.load(f)
    index = name2index[name]
    
    # Get the positive examples of this class
    with open('{}/{}/name2ids.json'.format(data_dir, fold), 'r') as f:
        name2ids = json.load(f)
    ids = name2ids[name]
    
    # Setup the labels for those examples
    labels = [1.0] * len(ids)
    labels = np.array(labels)
    
    # Get the file names of those examples
    files = ['{}/{}/images/{}.jpg'.format(data_dir, fold, i) for i in ids]
    
    # Get the model's representation of those examples
    with open('{}/{}/trial{}/{}.pkl'.format(base_dir, model, trial, fold), 'rb') as f:
        tmp = pickle.load(f)
        
    reps = []
    for i in ids:
        reps.append(tmp[i]['rep'])
    reps = np.array(reps)
    
    # Get the model predictions for those representations
    logits = []
    for i in ids:
        logits.append(tmp[i]['pred'][index])
    logits = np.array(logits)
    probs = sigmoid(logits)
    logits = np.squeeze(logits)
    probs = np.squeeze(probs)

    # Setup the output
    out = {}
    out['files'] = files
    out['reps'] = reps
    out['logits'] = logits
    out['probs'] = probs
    out['labels'] = labels
    
    return out

def load_imagenet(name, class_map):
    # Get the index for this class
    index = int(class_map[name][1])
    
    # Get the positive examples of this class
    with open('./Outputs/pretrained/{}.pkl'.format(name), 'rb') as f:
        data = pickle.load(f)
    ids = list(data)
    
    # Setup the labels for those examples
    labels = [index] * len(ids)
    labels = np.array(labels)
    
    # Get the file names of those examples
    files = ids
    
    # Get the model's representation of those examples
    reps = []
    for i in ids:
        reps.append(data[i]['rep'])
    reps = np.array(reps)
    
    # Get the model predictions for those representations
    logits = []
    for i in ids:
        logits.append(data[i]['pred'])
    logits = np.array(logits)
    
    # Setup the output
    out = {}
    out['files'] = files
    out['reps'] = reps
    out['logits'] = logits
    out['labels'] = labels
    
    return out
