
from torchvision.models import resnet50

from Features import Features

def get_model():
    model = resnet50(pretrained = True)
    for param in model.parameters():
        param.requires_grad = False
    model.eval()
    return model

def get_features(model):
    feature_hook = Features()
    handle = list(model.modules())[149].register_forward_hook(feature_hook)
    return feature_hook
