
import json
import matplotlib
matplotlib.use('agg')
import numpy as np
import os
from pathlib import Path
from subprocess import Popen
import sys
import time

sys.path.insert(0, '../Common/')
from Train import run

from Config import get_data_dir, id_from_path, get_out_features
    
# Handle system arguments
name = sys.argv[1]

verbose = False

# Setup output directories
base_dir = './Outputs/{}'.format(name)
os.system('rm -rf {}'.format(base_dir))
Path(base_dir).mkdir(parents = True, exist_ok = True)

# Setup dataset config
dc = ('{}/{}'.format(get_data_dir(), name), id_from_path, get_out_features())
trial = 0

# Run
for mode in ['pretrained', 'initial-transfer', 'initial-tune']:
    if verbose:
        print(mode)
    run(mode, trial, dc, base_dir = base_dir, select_metric = 'loss')
    time.sleep(np.random.uniform(4, 6))
    