
# Environment: scvis
import os
import pandas as pd
import sys

# Silence some warnings
os.environ['PYTHONWARNINGS']='ignore'
os.environ['TF_CPP_MIN_LOG_LEVEL']='2'
    
sys.path.insert(0, '../Common/')
from Load import load_standard

from Config import get_data_dir, get_out_features

# Handle system arguments
name = sys.argv[1]

verbose = False
    
# Setup output directories        
base_dir = './Outputs/{}/scvis'.format(name)
os.system('mkdir {}'.format(base_dir))
out_tmp = '{}/tmp.tsv'.format(base_dir)

# Get the model's representation of images from this class
out = load_standard('object', '{}/{}'.format(get_data_dir(), name), get_out_features(), base_dir = './Outputs/{}'.format(name), fold = 'test')
reps = out['reps']

df = pd.DataFrame(reps)
df.to_csv(out_tmp, sep = '\t', index = False)

# Run scvis
command = 'scvis train --data_matrix_file {} --out_dir {} --config_file ./scvis.yaml'.format(out_tmp, base_dir)
if verbose:
    command = '{} --verbose'.format(command)
os.system(command)

# Cleanup
os.system('rm -rf {}'.format(out_tmp))
