
import json

def get_data_dir():
    return '/home/gregory/Datasets/ILSVRC/Data/CLS-LOC'

def get_class_map():
    # Source:  https://raw.githubusercontent.com/raghakot/keras-vis/master/resources/imagenet_class_index.json
    # Note that this source has two classes named 'crane' and 'maillot', so those entries were modified
    with open('class_map.json', 'r') as f:
        tmp = json.load(f)
        
    class_map = {}
    for index in tmp:
        v = tmp[index]
        folder = v[0]
        name = v[1].replace("'", "")
        class_map[name] = [folder, index]

    return class_map

def get_names():
    class_map = get_class_map()
    return list(class_map)
    