wvs_topic_lists = {
    "Schwartz Basic Values": ["Self-Direction", "Stimulation", "Hedonism", "Achievement", "Power", "Security", "Conformity", "Tradition", "Benevolence", "Universalism"],
    "Hofstede Cultural Dimensions": ["Power Distance", "Individualism vs. Collectivism", "Masculinity vs. Femininity", "Uncertainty Avoidance", "Long-Term Orientation vs. Short-Term Normative Orientation", "Indulgence vs. Restraint"],
    "Ethics and Norms": ["Justice and Fairness", "Individual Rights", "Environmental Ethics", "Moral Duties and Altruism", "Environmental Ethics"],

    "Social Values, Attitudes & Stereotypes": ["Family", "Friendship & Social Networks", "Leisure & Work-Life Balance", "Political Engagement", "Work Ethic and Duty", "Religious Commitment", "Social Etiquette and Respect", "Personal Autonomy and Creativity", "Frugality and Responsibility", "Social Tolerance and Prejudice", "Gender Roles and Equality", "Work-Family Trade-offs", "Duty to Procreate & Caregiving", "Technological Progress Attitudes", "Authority and Social Order"],
    "Happiness and Well-being": ["Subjective Happiness", "Perceived Health", "Life Autonomy", "Global Life Satisfaction", "Financial Well-being", "Basic Needs Fulfillment", "Intergenerational Mobility"],
    "Social Capital, Trust & Organizational Membership": ["Interpersonal Trust", "Trust in Domestic Institutions", "Trust in Economic & Civic Organizations", "Trust in International Institutions", "International Organization Priorities", "Civic Knowledge & Awareness", "Organizational Membership"],
    "Economic Values": ["Income Equality vs. Incentives", "Ownership Preferences", "Welfare Responsibility", "Competition Attitudes", "Merit vs. Luck Beliefs", "General Economic Orientation"],
    "Corruption": ["Corruption", "Corruption Penetration", "Bribery Practices"],
    "Migration": ["Migration"],
    "Security": ["Perceived Personal Security", "Neighborhood Safety & Disorder", "Economic & Educational Security Concerns", "Crime Victimization", "Geopolitical Threat Perception", "Security vs. Freedom Trade-offs", "Civic Defense Willingness"],
    "Postmaterialist Index": ["Postmaterialist Index"],
    "Science & Technology": ["Science & Technology"],
    "Religious Values": ["Religious Values"],
    "Ethical Values and Norms": ["Dishonesty & Corruption Justifiability", "Sexual & Reproductive Ethics", "Life & Death Decisions", "Family Violence & Authority", "Interpersonal & Political Violence", "Surveillance & Privacy Rights", "Security vs. Civil Liberties Trade-off"],
    "Political Interest & Political Participation": ["Political Interest & Discussion", "Conventional Political Actions", "Electoral Engagement & Integrity"],
    "Political Culture & Political Regimes": ["Governance Model Preference", "Ideological Self-Placement", "Democratic Principle Importance", "Democratic Commitment & Evaluation", "Human Rights Respect", "National Pride & Belonging"]
}

wvs_topics = {
    ## Schwartz Basic Values
    "Self-Direction": "Self-direction: This refers to the pursuit of independent thought and action through choosing, creating, and exploring. Key elements include creativity, freedom, choosing own goals, curiosity, and independence, etc.",
    "Stimulation": "Stimulation: This represents the desire for excitement, novelty, and challenges in life. Key elements include adventurousness, a varied life, an exciting life and openness to new experiences, etc.",
    "Hedonism": "Hedonism: This value represents the pursuit of pleasure and sensuous gratification for oneself. Key elements include pleasure, enjoying life and self-indulgence in pleasurable activities, etc.",
    "Achievement": "Achievement: This value represents personal success through demonstrating competence according to social standards. Key elements include ambition, success, capability, intelligence and influence, etc.",
    "Power": "Power: This value refers to the desire for social status, prestige, control or dominance over people and resources. Key elements include authority, wealth, social power and social recognition, etc.",
    "Security": "Security: This represents the need for safety, harmony, and stability in society, relationships, life and self. Key elements include social order, family security, national security, healthy, predictability, and sense of belonging, etc.",
    "Conformity": "Conformity: This refers to the restraint of actions, inclinations and impulses that may upset or harm others and violate social norms. Key elements include obedience, self-discipline, politeness, respect for authority, honoring parents and elders, loyalty, etc.",
    "Tradition": "Tradition: Focuses on respect, commitment, and acceptance of traditional cultural or religious customs and ideas. Key elements include respect for tradition, humble, devout and spiritual life, etc.",
    "Benevolence": "Benevolence: This represents the preservation and enhancement of the welfare of those with whom one is in close relationships. Key elements include helpful, honest, forgiving, responsible, loyalty, kindness, generosity, true friendship and matrue love, etc.",
    "Universalism": "Universalism: This refers to understanding, appreciation, tolerance, and protection for the welfare of all people and nature. Key elements include broadminded,  equality, social justice, world at peace, world at beauty, unity with nature, wisdom and environmental care, etc.",

    ## Hofstede Cultural Dimensions
    "Power Distance Index": "Power Distance Index: This dimension measures the extent to which the less powerful members of institutions and organizations within a country expect and accept that power is distributed unequally, etc.",
    "Individualism vs. Collectivism": "Individualism vs. Collectivism: This dimension measures the degree to which individuals prioritize their own needs over group needs, etc.",
    "Uncertainty Avoidance Index": "Uncertainty Avoidance Index: The extent to which members of a culture feel comfortable with ambiguity, risk, and uncertainty, etc.",
    "Masculinity vs. Femininity": "Masculinity vs. Femininity: The preference for achievement, competition, and material success (masculinity) versus care, quality of life, and cooperation (femininity), etc.",
    "Long-Term Orientation": "Long-Term Orientation: The extent to which a culture values long-term planning, perseverance, and thrift over short-term gratification, etc.",
    "Indulgence vs. Restraint": "Indulgence vs. Restraint: The degree to which a culture allows for free gratification of desires and enjoyment of life, etc.",

    ## Social Norms and Ethics
    "Gender Roles": "Gender Roles: Refers to cultural expectations and behaviors assigned to genders. Key elements include roles in the family, workplace, and society, as well as attitudes toward gender equality and stereotypes, etc.",
    "Respect Elders": "Respect Elders: Explores how elders are treated and regarded in society. Key elements include deference, caregiving, decision-making authority, and intergenerational relationships, etc.",
    "Family Obligations": "Family Obligations: Refers to the responsibilities and expectations individuals have toward their family, including financial support, caregiving, and prioritizing family over personal needs, etc.",
    "Justice and Fairness": "Justice and Fairness: Encompasses cultural attitudes toward fairness, equality, and the application of justice. Key elements include perceptions of legal systems, social equality, and ethical decision-making, etc.",
    "Individual Rights": "Individual Rights: Focuses on the emphasis placed on personal freedoms, autonomy, and individual rights within society. Key elements include freedom of speech, privacy, and access to opportunities, etc.",
    "Social Norms": "Social Norms: Refers to unwritten rules and expectations governing appropriate behavior in social settings. Key elements include dress codes, public behavior, and communication styles, etc.",
    "Moral Duties and Altruism": "Explores the cultural emphasis on moral obligations and selfless acts for the welfare of others. Key elements include charity, volunteerism, and moral responsibility, etc.",
    "Environmental Ethics": "Environmental Ethics: Refers to cultural attitudes and practices toward nature and the environment. Key elements include sustainability, conservation, and ecological responsibility, etc.",
    "Health and Hygiene": "Health and Hygiene: Refers to cultural attitudes and practices related to health, wellness, and hygiene. Key elements include cleanliness standards, public health behaviors, hygiene-related taboos, healthcare-seeking behavior, personal grooming, etc.",
    "Ethnic Identity and Group Belonging": "Ethnic Identity and Group Belonging: Focuses on how individuals relate to and identify with ethnic, racial, or cultural groups, and how this shapes social behavior, values, and identity. Key elements include in-group vs. out-group perception, minority and majority dynamics, cultural pride, solidarity, intergroup relations, and shared ancestry or traditions, etc.",

    ## Social Values, Attitudes & Stereotypes
    "Family": "Explores the cultural significance of family as a social unit, including expectations around family roles, obligations, and intergenerational relationships. Key elements include family loyalty, caregiving responsibilities, and the role of family in personal identity.",
    "Friendship & Social Networks": "The importance placed on non-kin networks of trust, mutual support, and social cohesion as essential components of individual well-being.",
    "Leisure & Work-Life Balance": "Attitudes toward allocating time between work and personal activities, emphasizing well-being, rest, and the pursuit of interests outside professional obligations.",
    "Political Engagement": "The extent to which individuals feel responsible for, participate in, and influence civic affairs, governance, and public policy processes.",
    "Work Ethic and Duty": "Beliefs about diligence, responsibility, and the moral or civic imperative to contribute labor as a core value and social expectation.",
    "Religious Commitment": "The degree of personal faith, ritual observance, and moral guidance derived from religious traditions and institutions.",
    "Social Etiquette and Respect": "Norms governing polite behavior, deference, and consideration for others as fundamental to harmonious interpersonal interactions.",
    "Personal Autonomy and Creativity": "Valuing self-direction, independent thought, innovation, and perseverance as key drivers of individual fulfillment and societal progress.",
    "Frugality and Responsibility": "The emphasis on prudent resource management, saving, and a sense of accountability for personal and communal welfare.",
    "Social Tolerance and Prejudice": "Openness to diversity, acceptance of difference, and the rejection of bias based on ethnicity, religion, sexuality, health, or national origin.",
    "Gender Roles and Equality": "Culturally prescribed beliefs about appropriate behaviors, responsibilities, and opportunities for individuals based on their gender.",
    "Work-Family Trade-offs": "Attitudes toward balancing professional roles and family responsibilities, including gendered expectations in caregiving and employment.",
    "Duty to Procreate & Caregiving": "Norms that view childbearing and eldercare as moral or societal obligations embedded within family and community structures.",
    "Technological Progress Attitudes": "Perspectives on innovation, adoption of new technologies, and their perceived impact on social development and quality of life.",
    "Authority and Social Order": "The value placed on hierarchical structures, rule-based governance, and deference to recognized leadership for maintaining stability.",

    ## Happiness and Well-being
    "Subjective Happiness": "A broad measure of individuals' emotional well-being, capturing general feelings of joy, contentment, and positive mood that guide personal outlook and daily experiences.",
    "Perceived Health": "An overarching sense of physical and mental wellness, reflecting self-assessed vitality, absence of pain or illness, and confidence in one's ability to carry out daily activities.",
    "Life Autonomy": "The degree to which people feel they have freedom, choice, and personal agency in shaping their own life paths, decisions, and opportunities.",
    "Global Life Satisfaction": "A holistic evaluation of one's overall quality of life, weighing personal goals, achievements, relationships, and environmental factors to arrive at a sense of fulfillment.",
    "Financial Well-being": "The sense of security and satisfaction with one's economic circumstances, including income stability, ability to meet needs, and freedom from financial stress.",
    "Basic Needs Fulfillment": "The extent to which essential human requirements—such as adequate food, shelter, healthcare, income, and personal safety—are reliably met.",
    "Intergenerational Mobility": "Perceptions of social and economic progress across generations, comparing one's own standard of living and opportunities to those of one's parents.",

    ## Social Capital, Trust & Organizational Membership
    "Interpersonal Trust": "Refers to the general willingness to rely on and cooperate with others—family, neighbors, acquaintances, strangers, and individuals of different backgrounds—based on expectations of honesty, reliability, and benevolence.",
    "Trust in Domestic Institutions": "Denotes the level of confidence citizens place in national organizations and systems—government bodies, law enforcement, judiciary, media, educational and religious institutions—to act competently, fairly, and in the public interest.",
    "Trust in Economic & Civic Organizations": "Captures belief in the integrity and effectiveness of non-state actors—businesses, financial institutions, unions, charities, advocacy groups, and regional associations—to contribute responsibly to societal welfare and economic stability.",
    "Trust in International Institutions": "Describes faith in global governance bodies—United Nations, World Bank, IMF, WHO, WTO, ICC, NATO—to address cross-border challenges, uphold international norms, and balance effectiveness with legitimacy.",
    "International Organization Priorities": "Concerns opinions on whether global institutions should emphasize operational effectiveness or democratic accountability when making decisions that impact populations across nations.",
    "Civic Knowledge & Awareness": "Reflects familiarity with the structure, functions, and roles of major international and domestic organizations, indicating an individual's informed engagement with political and social systems.",
    "Organizational Membership": "Pertains to patterns of individual involvement—active or passive—in formal groups and associations (religious, professional, recreational, political, charitable, or mutual-aid) as an expression of social capital and community engagement.",

    "Income Equality vs. Incentives": "Refers to the balance between promoting a more equitable distribution of wealth through redistribution policies and preserving motivational rewards that drive individual productivity and innovation.",
    "Ownership Preferences": "Denotes attitudes toward the allocation of property rights, indicating whether economic assets and enterprises are best managed under private control or state stewardship.",
    "Welfare Responsibility": "Concerns beliefs about the primary actor responsible for social protection, contrasting expectations of government provision with the principle of individual self-reliance for basic needs.",
    "Competition Attitudes": "Captures perspectives on the role of competitive dynamics in the economy, weighing their potential to foster efficiency and growth against risks of social fragmentation and inequality.",
    "Merit vs. Luck Beliefs": "Assesses the degree to which success and social advancement are attributed to individual effort and talent versus external factors such as chance, connections, or inherited advantages.",
    "General Economic Orientation": "Represents an overarching philosophical stance on economic organization, encompassing views on regulation, market freedom, social equity, and the proper balance between collective welfare and individual liberty.",

    "Corruption": "Explores perceptions of corruption in public life and willingness to sanction it.",
    "Corruption Penetration": "Denotes the perceived depth and breadth of corrupt influence across institutions—government, business, civil service, and media—indicating how embedded unethical behavior is in social structures.",

    "Migration": "Refers to the movement of individuals or groups across geographic and cultural boundaries, encompassing processes of adaptation, identity negotiation, community formation, and cross-cultural exchange. It includes attitudes toward immigrants, emigration intentions, and diaspora ties.",

    "Perceived Personal Security": "Denotes individuals' subjective sense of safety and confidence in their immediate environment, encompassing freedom from physical harm, crime-related fears, and general peace of mind in daily life.",
    "Neighborhood Safety & Disorder": "Refers to the prevalence and impact of local disturbances—such as criminal activity, substance misuse, harassment, discrimination, and excessive authority intervention—that shape collective perceptions of community well-being and order.",
    "Economic & Educational Security Concerns": "Captures anxieties about maintaining stable livelihoods and securing opportunities for dependents, including fears of unemployment and inadequate access to quality education.",
    "Crime Victimization": "Describes the direct experiences and aftermath of being targeted by criminal acts, either personally or within one's family, highlighting tangible breaches of safety and trust.",
    "Geopolitical Threat Perception": "Reflects individuals' level of concern regarding large-scale dangers—such as war, terrorism, or civil unrest—that threaten national stability and international security.",
    "Security vs. Freedom Trade-offs": "Addresses normative judgments about the appropriate balance between safeguarding collective security and preserving individual liberties or social equality in policy and practice.",
    "Civic Defense Willingness": "Indicates the extent to which individuals express readiness to participate in collective defense or armed action for their community or nation as an expression of duty and solidarity.",

    "Postmaterialist Index": "Classifies respondents by materialist versus postmaterialist priorities (e.g. economic security vs. freedom).",

    "Science & Technology": "Probes cultural attitudes toward the role, value, and impact of scientific knowledge and technological innovation on personal well-being, social progress, ethics, faith, and future opportunities, guiding question development on perceived benefits, risks, moral considerations, and societal change.",

    "Religious Values": "Measures religious affiliation, practice, and the role of religion in public life, including beliefs about the importance of faith in daily life, moral guidance, and community belonging.",

    "Dishonesty & Corruption Justifiability": "Relates to judgments about whether deceptive, fraudulent, or illicit behaviors—such as theft, bribery, or benefit abuse—can ever be morally permissible under certain circumstances.",
    "Sexual & Reproductive Ethics": "Encompasses beliefs regarding the moral acceptability of behaviors and choices related to sexuality and reproduction, including consent, family planning, and non-traditional relationships.",
    "Life & Death Decisions": "Addresses ethical evaluations of actions that directly affect the preservation or termination of life, such as suicide, euthanasia, and capital punishment.",
    "Family Violence & Authority": "Concerns normative views on the legitimacy of using force or discipline within familial or hierarchical relationships, including corporal punishment and spousal violence.",
    "Interpersonal & Political Violence": "Involves moral attitudes toward the use of violence against individuals or groups for personal, political, ideological, or religious objectives, including terrorism and insurgency.",
    "Surveillance & Privacy Rights": "Concerns views on the balance between state monitoring powers—such as public surveillance and data collection—and individuals' rights to privacy and freedom from intrusive oversight.",
    "Security vs. Civil Liberties Trade-off": "Captures normative preferences regarding the prioritization of collective security measures versus the protection of individual freedoms and civil rights in policy and practice.",

    "Political Interest & Discussion": "Describes the degree of personal engagement with political issues, including proactive curiosity and the frequency of discussing public affairs with social networks.",
    "Conventional Political Actions": "Encompasses formal and informal civic behaviors—such as signing petitions, boycotts, demonstrations, strikes, donations, and direct advocacy—aimed at influencing policy or public opinion.",
    "Electoral Engagement & Integrity": "Refers to voter participation, perceptions of fairness, and commitment to clean elections, covering turnout, party choice, media impartiality, vote counting, and respect for democratic rules.",

    "Governance Model Preference": "Refers to individuals' normative attitudes toward various forms of political authority and decision-making structures, including authoritarian leadership, technocratic rule, military governance, theocratic systems, and representative democracy.",
    "Ideological Self-Placement": "Denotes a person's self-identified position on the political spectrum, reflecting their overarching views on government intervention, economic redistribution, and social hierarchy.",
    "Democratic Principle Importance": "Captures the degree to which specific institutional features—such as free elections, civil liberties, economic equality, military oversight, religious authority, and gender rights—are viewed as essential or contrary to democratic governance.",
    "Democratic Commitment & Evaluation": "Expresses both the personal valuation of living under democratic rule and the subjective assessment of how effectively democratic institutions function in practice.",
    "Human Rights Respect": "Reflects perceptions of the extent to which a society protects and upholds individual civil and political rights against infringement by state or nonstate actors.",
    "National Pride & Belonging": "Encompasses the emotional attachment and loyalty individuals feel toward their immediate communities, broader regions, nation, continent, and global humanity, as expressions of identity and solidarity.",

    "Social Values, Attitudes & Stereotypes": "Measures human beliefs about gender roles, family responsibilities, minorities, social hierarchy and so on.",
    "Happiness and Well-being": "Assesses subjective life satisfaction, emotional balance, and purpose.",
    "Social Capital, Trust & Organizational Membership": "Gauges trust in others and institutions, participation in voluntary associations, and norms of reciprocity.",
    "Economic Values": "Captures attitudes toward work ethics, redistribution, inequality, and market versus state.",
    # "Corruption": "Explores perceptions of corruption in public life and willingness to sanction it.",
    # "Migration": "Looks at attitudes toward immigrants, emigration intentions, and diaspora ties.",
    "Security": "Assesses citizens' sense of safety, fear of crime, and attitudes toward law enforcement.",
    # "Postmaterialist Index": "Classifies respondents by materialist versus postmaterialist priorities (e.g. economic security vs. freedom).",
    # "Science & Technology": "Probes trust in science, use of technology, and perceived impact on society.",
    # "Religious Values": "Measures religious affiliation, practice, and the role of religion in public life.",
    "Ethical Values and Norms": "Captures moral judgments about behaviors like lying, cheating, and loyalty.",
    "Political Interest & Political Participation": "Assesses interest in politics, voting behavior, protest engagement, and civic actions.",
    "Political Culture & Political Regimes": "Examines attitudes toward democracy, authority, and legitimacy of different regimes."
}

wvs_topics_examples = {
    "Self-Direction": ["How does your culture support individual exploration in education or career choices?", "Are people in your culture encouraged to pursue unconventional hobbies or career paths?", "What happens if someone in your culture rejects traditional norms to follow their own path?"],
    "Stimulation": ["How does your culture view activities like extreme sports or adventure travel?", "Are people encouraged to seek out new experiences, such as trying new cuisines or traveling to unfamiliar places?", "What are some examples of novelty or excitement that are celebrated in your culture?"],
    "Hedonism": ["What role do festivals or celebrations play in providing enjoyment and pleasure in your culture?", "Are indulgences like fine dining, luxury travel, or entertainment seen as a reward or a regular part of life?", "How does your culture balance work responsibilities with leisure and enjoyment?"],
    "Achievement": ["How are individual achievements recognized in your culture (e.g., awards, ceremonies)?", "What types of success (academic, professional, athletic) are most celebrated in your culture?", "Is failure seen as an opportunity for growth or a source of shame in your culture?"],
    "Power": ["What are the typical symbols of power and authority in your culture (e.g., titles, wealth, or influence)?", "How does your culture treat people in positions of authority, such as CEOs or politicians?", "Is it common for people to aspire to positions of social influence or dominance in your culture?"],
    "Security": ["What measures do families or communities take to ensure personal safety in your culture?", "Are long-term stability and predictability more valued than taking risks in your culture?", "How does your culture prepare for financial, environmental, or social uncertainties?"],
    "Conformity": ["How does your culture enforce rules or expectations, such as dress codes or social behavior?", "What happens if someone openly defies social norms in your culture?", "How important is it to follow traditional etiquette or manners in your culture?"],
    "Tradition": ["What are some traditional customs or rituals that are strictly followed in your culture?", "How does your culture preserve and pass on traditional practices to younger generations?", "Are there any traditional practices that have evolved or adapted to modern times?"],
    "Benevolence": ["How does your culture promote acts of kindness or generosity within families or communities?", "What are some ways people in your culture help friends or neighbors in need?", "Is there a sense of obligation to assist others, even at a personal cost?"],
    "Universalism": ["How does your culture address issues of diversity, such as accepting people of different religions or ethnicities?", "What role does environmental protection play in your culture's values?", "Are social justice initiatives widely supported in your culture, and how are they implemented?"],

    "Power Distance Index": ["How does your culture view the role of hierarchy in schools, such as the authority of teachers over students?", "What are the cultural expectations for addressing leaders or superiors in your workplace?", "Are decisions typically made collectively or by a single authority figure in your culture?"],
    "Individualism vs. Collectivism": ["How are family decisions made in your culture—do individuals decide, or is the family involved?", "How do people in your culture prioritize personal goals over obligations to family or community?", "What happens if someone prioritizes personal independence over group loyalty in your culture?"],
    "Uncertainty Avoidance Index": ["How does your culture approach decision-making in uncertain or ambiguous situations?", "What role do rules, laws, or traditions play in reducing uncertainty in your culture?", "Are people in your culture comfortable with breaking routines or embracing spontaneous plans?"],
    "Masculinity vs. Femininity": ["In your culture, how are gender roles reflected in family responsibilities or career paths?", "Is competition encouraged or discouraged in schools, workplaces, or sports in your culture?", "How does your culture emphasize care and cooperation versus success and achievement?"],
    "Long-Term Orientation": ["How does your culture emphasize planning for future generations versus immediate needs?", "Are traditions maintained for their cultural value, or are they adapted for practical reasons?", "How important is saving money or resources for the future in your culture?"],
    "Indulgence vs. Restraint": ["Are celebrations and festivals in your culture marked by indulgence or simplicity?", "How freely do people in your culture express emotions like joy, sadness, or anger in public?", "Is self-discipline considered more virtuous than the pursuit of pleasure in your culture?"],

    "Gender Roles": ["What roles are men and women traditionally expected to perform in your culture?", "How does your culture view women in leadership positions or traditionally male-dominated fields?"],
    "Respect Elders": ["What specific gestures or traditions are used to show respect for elders in your culture?", "How involved are elders in family decision-making or community leadership?"],
    "Family Obligations": ["What are the expectations for supporting extended family members in your culture?", "How does your culture view balancing individual independence with family obligations?"],
    "Justice and Fairness": ["How does your culture view the importance of fairness in resolving conflicts?", "What role does wealth or status play in determining justice in your culture?"],
    "Individual Rights": ["How does your culture balance individual rights with community responsibilities?", "What personal freedoms are most valued and protected in your culture?"],
    "Social Norms": ["What social norms dictate how people dress or behave in public spaces in your culture?", "How are violations of social norms typically handled in your culture?"],
    "Moral Duties and Altruism": ["How does your culture encourage helping strangers or those in need?", "What are some examples of altruistic behaviors that are widely admired in your culture?"],
    "Environmental Ethics": ["How does your culture view the relationship between humans and nature?", "What are some traditional practices or beliefs that promote environmental conservation in your culture?"],
    "Health and Hygiene": ["What practices or beliefs in your culture are associated with maintaining personal hygiene and cleanliness in daily life?", "How does your culture view the role of healthcare professionals in society?"],
    "Ethnic Identity and Group Belonging": ["How do people in your culture express a sense of belonging to their ethnic or cultural group in daily life?", "What role does ethnic identity play in shaping relationships between different groups within your society?"],

    "Social Values, Attitudes & Stereotypes": ["How important does family mean to people in your culture?", "How would you describe your society's views on the importance of higher education for people of different genders?", "In what ways does your community recognize or limit the rights of minority groups compared to the majority?"],
    
    "Happiness and Well-being": ["What role does community play in individual well-being in your society?", "Overall, how would you characterize the level of happiness and life satisfaction in your country?", "What factors do you think have the greatest impact on people's emotional well-being in your society?"],
    
    "Social Capital, Trust & Organizational Membership": ["How do people in your culture typically build trust with others?", "How would you describe the general level of trust among people in your community?", "How does social capital influence economic opportunities in your society?"],
    
    "Economic Values": ["How does your society balance the goal of economic equality with the need to reward hard work?", "How does your culture perceive the role of government in regulating the economy?"],
    
    "Corruption": ["What is the general public perception of corruption among public officials in your country?", "What are the common attitudes toward bribery and corruption in public life?", "How do people in your culture respond to corruption scandals?"],
    
    "Migration": ["What are the main reasons people choose to emigrate from your country, and what challenges do they face?", "How does your community generally feel about newcomers from other countries, and what factors shape those attitudes?"],
    
    "Security": ["How do people in your culture perceive their personal safety?", "What are the common attitudes toward law enforcement and crime prevention?", "How does your culture view the balance between security and individual freedoms?"],
    
    "Postmaterialist Index": ["How do people in your culture prioritize economic security versus freedom of expression?", "How does your culture view the role of government in promoting social welfare?"],
    
    "Science & Technology": ["How do people in your culture view the role of science in society?", "What are the common attitudes toward technological advancements and their impact on daily life?", "What role do scientists and technological experts play in shaping public policy and opinion in your society?"],
    
    "Religious Values": ["How does religion influence daily life in your culture?", "What are the common attitudes toward religious diversity in your society?", "How do people in your culture view the role of religion in public life?"],
    
    "Ethical Values and Norms": ["What are the common attitudes toward honesty and integrity in personal and professional relationships?", "How does your culture view the concept of loyalty?", "How do people in your culture view abortion?"],
    
    "Political Interest & Political Participation": ["How do people in your culture engage with politics?", "What are the common attitudes toward voting and civic participation?", "Which source do people in your culture learn about politics?"],
    
    "Political Culture & Political Regimes": ["How do people in your culture view democracy?", "What are the common attitudes toward authority and governance?", "How does your culture perceive the legitimacy of different political regimes?"],

    "Family": ["How are multigenerational family obligations prioritized in your community?",  "How do family roles and expectations evolve when children leave home?"],
    "Friendship & Social Networks": ["How do people cultivate and maintain friendships outside the family in your society?","What role do informal social networks play in finding jobs or opportunities in your culture?"],
    "Leisure & Work-Life Balance": ["How do individuals negotiate time between professional duties and personal hobbies in your culture?", "How acceptable is it to prioritize leisure over career advancement?"],
    "Political Engagement": ["How do citizens typically express opinions about government policy in your community?", "How do social gatherings incorporate discussions about current events and politics?"],
    "Work Ethic and Duty": ["What values do people associate with a strong work ethic in your culture?", "To what extent is overworking seen as admirable versus problematic?"],
    "Religious Commitment": ["What role do faith-based organizations play in public welfare in your society?", "How do families negotiate religious upbringing for children in a pluralistic context?"],
    "Social Etiquette and Respect": ["What unwritten rules govern polite behavior toward elders or authority figures?", "In what situations is formality required, and when is informality acceptable?"],
    "Personal Autonomy and Creativity": ["How is individual creative expression encouraged or constrained in your culture?","What rites of passage celebrate personal achievement and self-expression?", "How do educational systems balance conformity with innovation?"],
    "Frugality and Responsibility": ["How are habits of saving money and resources taught within families?", "What social sanctions exist against wastefulness or extravagance?", "How do community programs promote responsible consumption?"],
    "Social Tolerance and Prejudice": ["How does your culture address integration of minority or immigrant groups?", "What community efforts are in place to reduce discrimination and bias?", "How do schools teach children about respecting diverse backgrounds?"],
    "Gender Roles and Equality": ["How are responsibilities divided between men and women in household tasks?", "What ceremonies or rituals reflect changing gender expectations?", "How do individuals challenge traditional gender roles in public life?"],
    "Work-Family Trade-offs": ["How do working parents balance career ambitions with child-rearing duties?", "What leave policies exist to support family care during critical life events?", "How do perceptions of ideal parenthood influence employment choices?"],
    "Duty to Procreate & Caregiving": ["How is the expectation to have children expressed in family or religious traditions?","What societal supports exist for eldercare and intergenerational living?", "How do career-focused individuals negotiate parental responsibilities?"],
    "Technological Progress Attitudes": ["How do communities embrace or resist the introduction of new technologies?", "What debates arise around automation and job security?", "How is digital literacy integrated into education and daily routines?"],
    "Authority and Social Order": ["How do people view conformity to laws versus individual judgment in your society?", "What rituals reinforce respect for government or traditional leaders?", "How are acts of civil disobedience perceived in maintaining social order?"],


    "Subjective Happiness": ["How do people in your culture articulate what makes them feel happy?", "What customs or festivals are linked to communal joy and contentment?", "How is emotional well-being discussed across different age groups?"],
    "Perceived Health": ["How do individuals assess and report their overall physical well-being?", "How do communities respond to chronic illness or disability?"],
    "Life Autonomy": ["How do people in your culture define personal freedom and choice?", "What societal norms shape expectations around life decisions?", "How do individuals navigate family expectations versus personal aspirations?"],
    "Global Life Satisfaction": ["How do citizens evaluate the quality of life in comparison to other countries?", "What indicators do people use to judge societal well-being?"],
    "Financial Well-being": ["How do individuals perceive their financial stability and future prospects?", "What cultural attitudes shape spending versus saving behaviors?", "How do economic crises impact collective financial confidence?"],
    "Basic Needs Fulfillment": ["How do people in your culture define basic needs, and how are they met?", "What community resources exist to support those facing economic hardship?"],
    "Intergenerational Mobility": ["How do individuals perceive their chances of improving their social status compared to their parents?", "What factors are believed to influence upward mobility in your society?"],


    "Interpersonal Trust": ["How readily do people extend trust to strangers versus close acquaintances?", "What social cues influence judgments of honesty in everyday interactions?"],
    "Trust in Domestic Institutions": ["How much confidence do citizens place in local government versus national bodies?", "What factors increase or decrease trust in law enforcement and courts?", "How do historical events shape current institutional credibility?"],
    "Trust in Economic & Civic Organizations": ["How do people evaluate the reliability of banks and major companies?", "What role do NGOs and unions play in building community trust?", "How is corporate social responsibility perceived by the public?"],
    "Trust in International Institutions": ["How do citizens view the fairness and effectiveness of the United Nations or WHO?", "What international crises have influenced public confidence in global bodies?", "How do media narratives shape trust in multinational organizations?"],
    "International Organization Priorities": ["Should global institutions focus on achieving outcomes or upholding democratic values?", "How do people weigh efficiency versus accountability in international decision-making?"],
    "Civic Knowledge & Awareness": ["How familiar are individuals with the roles of major political and economic bodies?", "What educational experiences foster global civic literacy?", "How do informal networks contribute to understanding institutional functions?"],
    "Organizational Membership": ["What motivates people to join or leave social, religious, or professional groups?", "How do membership roles vary between active engagement and passive affiliation?", "What social benefits accrue from participating in community organizations?"],


    "Income Equality vs. Incentives": ["How do citizens perceive the balance between wealth redistribution and motivational rewards?", "What policies are favored to ensure fairness without dampening innovation?", "How are debates about taxation framed around equity and merit?"],
    "Ownership Preferences": ["How do different sectors (energy, healthcare) balance private ownership and state control?","What historical factors influence preferences for public versus private enterprises?","How is foreign investment viewed relative to domestic ownership?"],
    "Welfare Responsibility": ["Who should bear primary responsibility for social safety nets—government or individuals?", "How do family traditions intersect with public welfare expectations?", "What role do community charities play alongside state programs?"],
    "Competition Attitudes": ["How is market competition portrayed in education and employment?", "What cultural norms regulate rivalry versus collaboration?", "How do people reconcile competitive success with communal values?"],
    "Merit vs. Luck Beliefs": ["To what extent is personal success attributed to hard work versus external fortunate factors?", "How do narratives of self-made achievement shape career aspirations?", "What role do family connections play in opportunity access?"],
    "General Economic Orientation": ["How do citizens articulate their overall philosophy on market freedom and social equity?", "What terms do people use to describe ideal economic systems?", "How does economic orientation align with cultural notions of fairness?"],

    "Corruption": ["How do everyday citizens perceive the prevalence of corruption in public office?", "What forms of corrupt behavior are most condemned or tolerated?", "How does media coverage shape cultural attitudes toward corruption?"],
    "Corruption Penetration": ["In which sectors (judiciary, bureaucracy, business) is corruption perceived as most deeply rooted?", "How do trust levels in institutions change with reports of systemic corruption?", "What historical events have influenced the depth of corrupt practices?"],

    "Migration": ["How do communities perceive incoming migrants and their cultural integration?", "What economic or social factors motivate citizens to emigrate?", "How are migration policies debated in public forums?"],

    "Perceived Personal Security": ["How safe do you generally feel walking alone in your city after dark, and what factors influence that feeling?", "In your culture, what everyday actions do people take to enhance their own sense of safety?", "To what extent do feelings of personal security impact interpersonal trust in your community?"],
    "Neighborhood Safety & Disorder": ["How do residents in your neighborhood perceive the frequency of public disturbances like street fights or harassment?", "What informal community practices exist in your area to address minor crimes or antisocial behavior?", "How does media coverage of local crime shape collective views of neighborhood safety?"],
    "Economic & Educational Security Concerns": ["How worried are families in your culture about securing stable employment and affording quality schooling for their children?", "What social supports or norms exist to help households cope with financial insecurity?", "In your society, how is the value of education framed as a pathway to economic security?"],
    "Crime Victimization": ["How do individuals in your culture react when someone they know falls victim to crime, and what community responses follow?", "What legal or social mechanisms are most trusted for redressing personal losses from crime?", "How does the fear of becoming a victim influence people's daily routines and habits?"],
    "Geopolitical Threat Perception": ["What are common public attitudes toward the threat of war or international conflict in your country?", "How do people balance concerns about terrorism versus other types of security risks?", "In your culture, how are global security threats discussed in family or social circles?"],
    "Security vs. Freedom Trade-offs": ["How do citizens in your society debate the balance between increased surveillance and preserving personal liberties?", "What examples illustrate moments when your culture prioritized security over individual freedom?", "How would you describe public opinion on adopting strict security measures that limit certain rights?"],
    "Civic Defense Willingness": ["Under what circumstances do people in your culture feel compelled to take up arms or organized defense?", "How is the concept of national duty to defend the country taught or encouraged in your society?", "What social rituals or symbols reinforce willingness to serve in defense of your community or nation?"],

    "Postmaterialist Index": ["How do people in your culture balance concerns for economic growth against environmental preservation and personal well-being?", "What social movements reflect a shift from material priorities to values like self-expression and quality of life?", "In what ways do younger generations in your society express postmaterialist attitudes compared to their parents?"],

    "Science & Technology": ["How do citizens in your culture view the role of new technologies in shaping everyday social interactions?", "What ethical debates around emerging scientific innovations are most prominent in your society?", "In what ways do traditional beliefs influence acceptance or rejection of modern scientific practices?"],

    "Religious Values": ["How do religious beliefs inform moral decisions and daily routines in your culture?", "What communal rituals express the core spiritual values of your society?", "How do people navigate conflicts between religious teachings and secular laws?"],

    "Dishonesty & Corruption Justifiability": ["Under what circumstances, if any, do people in your society view minor corruption as acceptable?", "How is cheating or theft discussed morally within families or peer groups?", "What cultural narratives justify or condemn acts of dishonesty at work or in public life?"],
    "Sexual & Reproductive Ethics": ["How do social attitudes toward premarital relationships reflect broader cultural norms on sexuality?", "In what ways do debates over reproductive rights surface in your community's public discourse?", "How are non-traditional family structures accepted or stigmatized in your culture?"],
    "Life & Death Decisions": ["How do individuals in your society approach decisions around end-of-life care and assisted dying?", "What moral frameworks guide attitudes toward self-harm or voluntary death?", "How is the death penalty debated in light of cultural notions of justice and compassion?"],
    "Family Violence & Authority": ["What cultural beliefs sanction or reject the use of corporal punishment within families?", "How do community leaders respond to domestic abuse in your society?", "In what ways is authority within the household negotiated between generations?"],
    "Interpersonal & Political Violence": ["How does your culture perceive the moral legitimacy of protest-related violence?", "What historical events influence contemporary attitudes toward political aggression?", "How are acts of personal assault versus collective violence morally distinguished in your society?"],
    "Surveillance & Privacy Rights": ["How do citizens weigh the benefits of public surveillance against concerns for personal privacy?", "What legal or customary limits exist on monitoring digital communications in your culture?", "In what contexts do people feel it is acceptable for authorities to access private information?"],
    "Security vs. Civil Liberties Trade-off": ["How do policy debates in your society navigate the tension between ensuring public safety and protecting individual rights?", "What examples illustrate a cultural tipping point favoring security over civil freedoms?", "How is the concept of 'state of exception' justified or criticized in public discourse?"],

    "Political Interest & Discussion": ["What social settings encourage regular conversations about politics among friends and family in your culture?", "How is political curiosity nurtured or discouraged during schooling or community life?", "How do generational differences affect political interest in your society?"],
    "Conventional Political Actions": ["What motivates individuals in your culture to sign petitions or join peaceful demonstrations?", "How do community groups organize boycotts or strikes to influence local policy?", "In what ways do people use digital tools or social media to mobilize political support?"],
    "Electoral Engagement & Integrity": ["How do voters in your country assess the fairness of election procedures and vote counting?", "What factors influence whether citizens choose to vote in local versus national elections?", "How is trust in electoral institutions maintained or eroded in your political culture?"],

    "Governance Model Preference": ["What arguments do people in your country use to support strongman rule versus parliamentary democracy?", "How is technocratic governance viewed in relation to electoral representation in your society?", "In what contexts do citizens express support for religious or military rule?"],
    "Ideological Self-Placement": ["How would individuals in your culture describe their political identity on a left-to-right spectrum?", "What historical or cultural factors influence self-placement on ideological scales?", "How fluid are ideological labels like 'left' or 'right' across generations in your society?"],
    "Democratic Principle Importance": ["Which democratic feature—free elections, civil liberties, social equality—do people in your culture deem most vital?", "How do citizens debate the role of military intervention versus civilian rule in maintaining democracy?", "What tensions arise between religious authority and democratic governance in public discourse?"],
    "Democratic Commitment & Evaluation": ["How important is it for you personally to live under a democratic system, and why?", "How do residents evaluate the current performance of democratic institutions in delivering public goods?", "In what ways is citizen satisfaction with governance measured or expressed in your culture?"],
    "Human Rights Respect": ["How do people perceive the protection of civil liberties, such as free speech and assembly, in their country?", "What symbols or rituals reinforce the value of individual rights in your society?", "How is state overreach into personal freedoms discussed in popular culture?"],
    "National Pride & Belonging": ["What cultural practices foster a strong sense of national or local belonging among citizens?", "How do individuals express pride in their nationality during public events or festivals?", "In what ways do regional or global identities coexist with national loyalty in your culture?"]
}

point_extraction_prompt = """You are an expert at extracting concise cultural insights from open-ended text. 
You will be given a culture-related question and its response. Your task is to summarize the cultural points reflected in the response, each as a one-sentence summary of a culture insight. The points should be phrased generally so they can be merged across different responses, avoid specific names or numbers.

Example 1:
Q: How does your culture support individual exploration in education or career choices?
A: In my culture, individual exploration in education and career choices is deeply valued and encouraged. Our culture promotes the idea that everyone can pursue their passions, regardless of their background. Community colleges and vocational training programs offer accessible pathways for those like me, allowing us to gain skills and certifications that lead to stable jobs. Additionally, the emphasis on personal stories and diverse experiences fosters an environment where non-traditional paths are celebrated. Support from family and local networks plays a crucial role, as we often share our journeys and uplift one another in our pursuits.
Cultural points:
1. Personal passion and choice are highly valued regardless of background.
2. Accessible education and training pathways enable skill development.
3. Non-traditional educational or career routes are celebrated.
4. Family and local community networks provide encouragement.
5. Sharing personal stories builds a culture of mutual support.

Example 2:
Q: How does your culture support individual exploration in education or career choices?
A: In my culture, individual exploration in education and career choices is deeply embedded in our cultural values of freedom and self-expression. The education system encourages diverse paths, offering a wide range of majors and vocational programs that cater to various interests and talents. Moreover, societal support for entrepreneurship and innovation fosters a mindset where taking risks is celebrated. Resources like mentorship programs and networking opportunities further empower individuals to explore different career trajectories. This cultural emphasis on personal choice and the belief that anyone can shape their destiny motivates us to pursue our passions, leading to a vibrant and dynamic workforce.
Cultural points:
1. Individual exploration is rooted in freedom and self-expression.
2. Diverse academic and vocational options cater to varied talents.
3. Risk-taking and innovation are socially encouraged.
4. Mentorship and professional networks empower exploration.
5. Belief in personal agency drives pursuit of passions.
6. Dynamic workforce reflects cultural emphasis on personal choice.

Here is the provided culture-related question and response.
Q: {question}
A: {response}
Your task is to extract cultural points from the response and output them in the following format. Do not output any other text.
Cultural points:
1. <first cultural point>
2. <second cultural point>
...
"""

no_culture_answer = """Given a culture-related question, please answer it based on your own cultural values, beliefs and social practices.
The question is:
{question}

Your response is:"""

"""You are a {country} culture expert, with 15 years of experience as a {role}. Thus, you have deep knowledge of {country} culture values, beliefs and social practices. Given a culture-related question, please answer it with your expertise and knowledge about {country} culture. You should follow the guidelines below:
1. Highlight points that are related to the question, representative and widely accepted in {country} culture.
2. Highlight aspects that are representative and generalized, not specific to a single event or context.
3. Focus only on the cultural answer; do not restate the question, explain the task, or mention this prompt.
4. Answer the question within 150 words, then output the answer text only, with no additional commentary.

Here is the question:
{question}

Your response is:"""

main_culture_answer_expert_role = """You are a {country} culture expert, with 15 years of experience as a {role}. Thus, you have deep knowledge of {country} culture values, beliefs and social practices. Given a culture-related question, please answer it with your expertise and knowledge about {country} culture, following the guidelines below:
1. Highlight points that are related to the question, representative and widely accepted in {country} culture.
2. Emphasize points that are distinctive and unique to {country} culture, compared to other cultures.
3. Focus only on the cultural answer; do not restate the question, explain the task, or mention this prompt.



Here is the culture-related question:
{question}

To help you think more deeply about the distinctiveness and uniqueness of {country} culture, several responses from people of other countries are provided below. Reflect on these responses and consider how {country} culture might approach this topic differently. Responses from other countries:
{other_response}

Please frame your response within 200 words. Output the answer text only, with no additional commentary.
Your response is:"""

### Prompts for generating representative & distinctive questions
represent_distinctive_question_generate_prompt = """You are a {country} culture expert with deep knowledge of cultures, values and social practices of {country} and those of other countries. 

Given a cultural value topic from the Schwartz Theory of Basic Values, Hofstede's Cultural Dimensions, or World Value Survey, your task is to generate 3-5 diverse questions or scenarios around this topic to explore the representative and unique values, beliefs and social norms of {country} culture.

You should follow all these guidelines for generation:
1. Topic Relevance: Question should explore cultural characteristics around the given topic.
2. Culture Consensus: Question should focus on values, beliefs and social practices that are representative, widely accepted and frequently appeare in {country} culture. Avoid niche, rare, or extreme viewpoints.
3. Culture Representativeness: Question should capture generalized values, beliefs and social practices of {country} culture that can be guidance across various situations, not be too specific to a single event or context.
4. Culture Distinctiveness: Choose questions or scenarios where people from {country} are likely to respond differently from people in other cultures, i.e., the answers are likely to be different across cultures. Avoid questions whose answers are likely to be identical across most cultures.
5. Diversity: Each generated question should cover different aspects of the topic and differ from the provided example questions.
6. Neutral phrasing: Do not explicitly mention '{country}' in the question, so that it can be used to interview people from any cultural backgrounds to uncover the distinctiveness, i.e., avoid using like "In {country}, how do people...?" or "In {country} culture, what is the view on...?" in the question.

Generated questions should be one of the following types:
- Scenario-based question: Present a realistic value-related scenario and ask how people might react.
- Value-oriented question: Ask how people might prioritize or value certain principles or beliefs.
- Open-ended question: Encourage people to share their thoughts, feelings, and experiences related to a cultural aspect in detail.
- Likert-scale attitude question: Ask respondents to indicate their degree of agreement or priority regarding specific cultural value statements, like such as questions in World Value Survey or other surveys.

Here is the cultural topic that you need to generate questions for. (The provided definition is only a reference but not a complete description, you can further explore it based on your knowledge)
Cultural Topic: {topic}

Example Questions
[example 1]: {example_1}
[example 2]: {example_2}

Please generate 3-5 new questions following the guidelines above. Output exactly in the following format, without any other text.
[question 1]: <text of the question> (scenario-based question / value-oriented question / open-ended question / Likert-scale attitude question)
[question 2]: <text of the question> (...)
... (up to 5 questions)

The generated questions are:
"""

rep_dist_answer_demographic_role = """You are a {country} citizen with the following demographic information:
{demographic_info}

You know {country} culture well from your own viewpoints as this persona, including the cultural values, beliefs and social practices. Given a culture-related question, please answer it with cultural awareness, following the guidelines below:
1. Highlight points that are related to the question, representative and widely accepted in {country} culture.
2. Highlight aspects that are representative and generalized, not specific to a single event or context.
3. Emphasize points that are distinctive and unique to {country} culture, compared to other cultures. To help you think more deeply, several responses from people of other countries are provided. Reflect on these responses and consider how {country} culture might approach this topic differently.
4. Focus only on the cultural answer; do not restate the question, explain the task, or mention this prompt.
5. Answer the question within 150 words, then output the answer text only, with no additional commentary.

Here is the question:
{question}

Responses from other countries:
{other_response}

Your response is:"""

rep_dist_answer_expert_role = """You are a {country} culture expert, with 15 years of experience as a {role}. Thus, you have deep knowledge of {country} culture values, beliefs and social practices. Given a culture-related question, please answer it with your expertise and knowledge about {country} culture. You should follow the guidelines below:
1. Highlight points that are related to the question, representative and widely accepted in {country} culture.
2. Highlight aspects that are representative and generalized, not specific to a single event or context.
3. Emphasize points that are distinctive and unique to {country} culture, compared to other cultures. To help you think more deeply, several responses from people of other countries are provided. Reflect on these responses and consider how {country} culture might approach this topic differently.
4. Focus only on the cultural answer; do not restate the question, explain the task, or mention this prompt.
5. Answer the question within 150 words, then output the answer text only, with no additional commentary.

Here is the question:
{question}

Responses from other countries:
{other_response}

Your response is:"""

rep_dist_reflection_prompt = """You are an expert in {country} culture, with deep knowledge of {country} culture values, beliefs and social practices, as well as those of other cultures across the world. Given a culture-related question under a topic, you need to refine it so that it can better elicit widely accepted, representative and distinctive features of {country} culture towards this question compared to other cultures.

I will provide you with the following information:
[Cultural Topic]: <The cultural topic for the question>
[Question]: <The original question that needs refinement>
[Response from {country} (target culture)]: <in the format fine-grained cultural points, each with an acceptance and representativeness score from 0 (low) to 1 (high)>
    [Point 1]: <cultural point> (score: <score>)
    [Point 2]: <cultural point> (score: <score>)
    ... (more points if available)
[Response from other countries]:
    [Country 1]: <response points from country 1>
    [Country 2]: <response points from country 2>
    ... (more countries if available)
[Representativeness reward]: <The reward score is the count of high-scoring cultural points in {country} answer elicited by this question>
[Distinctiveness reward]: <The reward score is the distance between the response of {country} and other cultures, with a higher score indicating more distinctiveness>

To refine the question to achieve both a higher representativeness reward and a higher distinctiveness reward, you should consider several improvement directions:
1. Cultural Consensus: Analyze both the high-scoring (score > 0.85) and low-scoring (score < 0.8) cultural points to identify which are more widely accepted features of {country} culture, then, refine the question to i) keep the high-scoring points, ii) avoid low-scoring points, and iii) encourage new relevant high-scoring points that are not yet covered.
2. Cultural Representativeness: Ensure the question is not tied to a single event or context, but capture points generalized across various situations. 
3. Cultural Distinctiveness: Identify features where {country} significantly differ from other cultures, then refine the question to better elicit these distinctive features while avoiding points common across cultures.
4. Question-Answer Consistency: Ensure the question is coherent with the high-scoring points, avoid overly vague or generic wording.

Here is the input:
[Cultural Topic]: {topic}
[Question]: {question}
[Response from {country} (target culture)]:
{cultural_points}
[Response from other countries]:
{other_response}
[Representativeness reward]: {representativeness_reward}
[Distinctiveness reward]: {distinctiveness_reward}

In this first step, you should give some suggestions to improve this question based on the above information within 150 words, but don't give your refined one, only suggestions.
"""

rep_dist_refine_prompt = """Based on your provided suggestions, please refine the above question. You should keep it aligned with the original cultural topic, avoid making the question too long, detailed or multipart. Please only output the refined question, do not output any other text.
Refined Question:
"""