# Adversarial Robustness of Continuous Time Dynamic Graphs

A comprehensive framework for evaluating adversarial robustness of Temporal Graph Neural Networks (TGNNs) on Continuous-Time Dynamic Graphs (CTDGs).

![TRBCD workflow](imgs/trbcd-main.png)

## Overview

This repository implements and evaluates adversarial attacks on temporal graph neural networks, focusing on:
- **Structural perturbations** on dynamic graph topology
- **Temporal consistency** in adversarial attacks
- **Evasiveness evaluation** using anomaly detection systems
- **Comprehensive benchmarking** across multiple datasets and models

## Key Features

- **Novel Attack Method**: TR-BCD (Temporal Robustness Binary Constraint Descent) with gradient-based optimization
- **Temporal Graph Support**: Works with continuous-time dynamic graphs
- **Multiple Attack Strategies**: Random, Historical, MemStranding, and our proposed method
- **Anomaly Detection Integration**: SPOTLIGHT-based evasiveness evaluation
- **Comprehensive Evaluation**: Performance metrics across 6 diverse datasets

## Installation

### Prerequisites
- Python 3.8+
- CUDA-compatible GPU (recommended)

### Setup
```bash
# Clone the repository
git clone <repository-url>
cd TGB

# Create and activate conda environment
conda create -n tgnn python=3.8
conda activate tgnn

# Install dependencies
pip install -r requirements.txt
```

## Quick Start

### Basic Usage
```bash
# Run a single experiment
python main.py --config configs/tgn_tgbl-wiki_trbcd.yaml

# Run with different attack strategies
python main.py --config configs/tgn_tgbl-wiki_memstranding.yaml
```

### Batch Experiments with SLURM
```bash
# Install SEML for workload management
pip install seml

# Configure SEML
seml configure

# Add experiment to queue
seml add configs/tgn_tgbl-wiki_trbcd.yaml

# Start experiments
seml start
```

## Configuration

Experiments are configured using YAML files in the `configs/` directory:

- **Model configurations**: `tgn_tgbl-wiki.yaml`, `tncn_tgbl-wiki.yaml`
- **Attack strategies**: `*_trbcd.yaml`, `*_memstranding.yaml`, `*_random.yaml`
- **Dataset settings**: Configured per dataset (Wikipedia, MOOC, etc.)

### Example Configuration
```yaml
model:
  name: "tgn"
  hidden_dim: 100
  num_layers: 2

attack:
  name: "trbcd"
  budget: 0.05
  num_epochs: 100

dataset:
  name: "tgbl-wiki"
  batch_size: 200
```

## Datasets

The framework supports multiple temporal graph datasets:

- **Wikipedia**: Edit interactions on Wikipedia pages
- **MOOC**: Student interactions in online courses  
- **Reddit**: User interactions on Reddit
- **Enron**: Email communications
- **UCI**: Social network interactions
- **LastFM**: Music listening patterns

## Attack Methods

### TR-BCD (Our Method)
- **Gradient-based optimization** for edge selection
- **Temporal consistency** preservation
- **Mixed initialization** strategy with historical negatives

### Baselines
- **Random**: Random edge perturbations
- **Historical**: Insertion of historical negative edges
- **MemStranding**: Node-targeted attack with fake neighbors

## Evaluation Metrics

- **Mean Reciprocal Rank (MRR)**: Primary performance metric
- **Anomaly Detection Scores**: SPOTLIGHT-based evasiveness evaluation
- **Attack Success Rate**: Effectiveness of adversarial perturbations
- **Temporal Consistency**: Smoothness of attack patterns



## File Structure

```
TGB/
├── configs/           # Experiment configurations
├── data/             # Dataset processing scripts
├── models/           # TGNN model implementations
├── attacks/          # Attack method implementations
├── utils/            # Utility functions
├── spotlight_data/   # output directory for nomaly detection results
└── logs/             # Experiment logs
```

