#!/bin/bash

data_directory=<your_data_directory>

modelset=('EGNN_cpl_global' 'EGNN_cpl_local')
layers=({1..4})

generate_commands() {
    for model in ${modelset[@]}; do
        for layer in ${layers[@]}; do
            echo --model $model --num_layer $layer
        done
    done
}

generate_commands | parallel -j4 --colsep ' ' --lb \
    CUDA_VISIBLE_DEVICES='$(( ({%} - 1) % 4 ))' python ./main_nbody.py \
        --data_directory "$data_directory" \
        --dataset_name '5_0_0' \
        --seed 43 \
        --early_stop 1000 \
        --device 'cuda:0' {1} {2} {3} {4}
        