#!/bin/bash

data_directory=<your_data_directory>

labelset=('M' 'T' 'I')
modelset=('TFN_cpl_local')
layers=({1..4})

generate_commands() {
    for label in ${labelset[@]}; do
        for model in ${modelset[@]}; do
            for layer in ${layers[@]}; do
                echo --label_type $label --model $model --num_layer $layer
            done
        done
    done
}

generate_commands | parallel -j4 --colsep ' ' --lb \
    CUDA_VISIBLE_DEVICES='$(( ({%} - 1) % 4 ))' python ./main_tetrahedron.py \
        --data_directory "$data_directory" \
        --seed 43 \
        --device 'cuda:0' {1} {2} {3} {4} {5} {6}
