#!/bin/bash

data_directory=<your_data_directory>

molset=('aspirin' 'benzene' 'ethanol' 'malonaldehyde' 'naphthalene' 'salicylic' 'toluene' 'uracil')
modelset=('EGNN_cpl_global' 'EGNN_cpl_local')
layers=({1..4})
seedset=({43..45})

for seed in "${seedset[@]}"; do
for layer in "${layers[@]}"; do
for model in "${modelset[@]}"; do
    python ./main_md17.py \
        --model $model \
        --data_directory $data_directory \
        --mol_type $mol_type \
        --num_layer 4 \
        --seed $seed \
        --early_stop 100 \
        --device 'cuda:0'
done
done
done