#!/bin/bash

data_directory=<your_data_directory>

molset=('aspirin' 'benzene' 'ethanol' 'malonaldehyde' 'naphthalene' 'salicylic' 'toluene' 'uracil')
modelset=('EGNN_cpl_global' 'EGNN_cpl_local')
seedset=({43..45})

generate_commands() {
    for seed in ${seedset[@]}; do
    for mol_type in ${molset[@]}; do
    for model in ${modelset[@]}; do
        echo  --mol_type $mol_type --model $model --seed $seed
    done
    done
    done
}

generate_commands | parallel -j4 --colsep ' ' --lb \
    CUDA_VISIBLE_DEVICES='$(( ({%} - 1) % 4 ))' python ./main_md17.py \
        --data_directory $data_directory \
        --num_layer 4 \
        --early_stop 100 \
        --device 'cuda:0' {1} {2} {3} {4} {5} {6}
