import gym
from stable_baselines3 import PPO
import numpy as np
from gym_macro_overcooked.overcooked_V1 import Overcooked_V1
from stable_baselines3.common.callbacks import BaseCallback
from stable_baselines3.common.logger import configure
import matplotlib.pyplot as plt
from gym_macro_overcooked.items import Tomato, Lettuce, Onion, Plate, Knife, Delivery, Agent, Food, DirtyPlate
import random
import time
import torch
import os




# —— 锁线程数，防止并行库抢核 —— #
os.environ.setdefault("OMP_NUM_THREADS", "1")
os.environ.setdefault("MKL_NUM_THREADS", "1")
os.environ.setdefault("OPENBLAS_NUM_THREADS", "1")
os.environ.setdefault("NUMEXPR_NUM_THREADS", "1")
# （可选）让 PyTorch 在 CPU 上只用 1 线程
torch.set_num_threads(1)
torch.set_num_interop_threads(1)



# ====== 全局随机种子 ======
SEED = 42  # 你可以修改这个数字来改变随机性

random.seed(SEED)
np.random.seed(SEED)
torch.manual_seed(SEED)
if torch.cuda.is_available():
    torch.cuda.manual_seed_all(SEED)




# ==== Step 1: Extend SB3 policy to expose action probabilities ====
from stable_baselines3.ppo.policies import MlpPolicy
import torch

def get_action_prob(self, obs):
    if obs.ndim == 1:
        obs = obs[np.newaxis, :]
    obs_tensor = torch.tensor(obs, dtype=torch.float32).to(self.device)

    with torch.no_grad():
        features = self.extract_features(obs_tensor)             # 👈 抽取原始特征
        latent_pi, _ = self.mlp_extractor(features)              # 👈 通过策略网络映射
        dist = self._get_action_dist_from_latent(latent_pi)      # 👈 得到策略分布
        return dist.distribution.probs.cpu().numpy().squeeze()




MlpPolicy.get_action_prob = get_action_prob

# ==== Step 2: Define PE bonus calculation ====
def compute_population_entropy_bonus(state, action, population, alpha):
    # print("🧪 state type:", type(state))
    # print("🧪 state content:", state)

    probs = []
    for agent in population:
        try:
            p = agent.policy.get_action_prob(state)
            # print("action prob dist:", p)
            probs.append(p[action])
        except Exception as e:
            print(f"⚠️ Error computing PE bonus: {e}")
            continue

    if len(probs) == 0:
        return 0.0
    avg_prob = np.mean(probs)
    return -alpha * np.log(avg_prob + 1e-8)


# ==== Step 3: Rank-based prioritized sampling from population ====
def prioritized_sampling(agent_A, population, eval_env, beta=1.0):
    returns = []
    for partner in population:
        total_reward = 0
        obs = eval_env.reset()
        done = False
        while not done:
            a_action, _ = agent_A.predict(obs[0], deterministic=True)
            b_action, _ = partner.predict(obs[1], deterministic=True)
            low_level_actions, _ = eval_env._computeLowLevelActions([a_action, b_action])
            obs, reward, done, _ = eval_env.step(low_level_actions)

            obs = eval_env._get_macro_obs()
            total_reward += reward[0]  # focus on agent_A's reward
        returns.append(total_reward)

    difficulty = [1.0 / (r + 1e-6) for r in returns]  # lower return = higher difficulty
    sorted_idx = np.argsort(difficulty)[::-1]  # harder first
    ranks = np.empty_like(sorted_idx)
    ranks[sorted_idx] = np.arange(1, len(difficulty) + 1)
    weights = ranks.astype(np.float32) ** beta
    probs = weights / np.sum(weights)
    selected_idx = np.random.choice(len(population), p=probs)
    return selected_idx






ITEMNAME = ["space", "counter", "agent", "tomato", "lettuce", "plate", "knife", "delivery", "onion", "dirtyplate", "badlettuce"]

macroActionDict = {"stay": 0, "get lettuce 1": 1, "get lettuce 2": 2, "get badlettuce": 3, "get plate 1": 4, "get plate 2": 5, "go to knife 1": 6, "go to knife 2": 7, "deliver 1": 8, "deliver 2": 9, "chop": 10, "go to counter": 11, "right": 12, "down": 13, "left": 14, "up": 15}


def find_best_reachable_index(can_reach_1, can_reach_2, can_reach_3, distance_1, distance_2, distance_3):
    reachable_indices = []
    distances = []
    
    # 收集可达的索引和对应距离
    if can_reach_1 != 4:
        reachable_indices.append(0)
        distances.append(distance_1)
    if can_reach_2 != 4:
        reachable_indices.append(1)
        distances.append(distance_2)
    if can_reach_3 != 4:
        reachable_indices.append(2)
        distances.append(distance_3)
    
    if not reachable_indices:
        return False  # 没有可达的位置
    
    # 如果只有一个可达位置，直接返回该索引
    if len(reachable_indices) == 1:
        return reachable_indices[0]
    
    # 否则，返回距离最小的索引
    min_distance_index = reachable_indices[distances.index(min(distances))]
    return min_distance_index


def intelligently_find_item_number(env, agent_item, raw_name):

    if raw_name == "get plate":
        target_x_1, target_y_1 = env._findPOitem(agent_item, macroActionDict[raw_name + " 1"])
        can_reach_1 = env._navigate(agent_item, target_x_1, target_y_1)
        distance_1 = env._calDistance(target_x_1, target_y_1, agent_item.x, agent_item.y)

        target_x_2, target_y_2 = env._findPOitem(agent_item, macroActionDict[raw_name + " 2"])
        can_reach_2 = env._navigate(agent_item, target_x_2, target_y_2)
        distance_2 = env._calDistance(target_x_2, target_y_2, agent_item.x, agent_item.y)

        target_x_3, target_y_3 = env._findPOitem(agent_item, macroActionDict["get dirty plate"])
        can_reach_3 = env._navigate(agent_item, target_x_3, target_y_3)
        distance_3 = env._calDistance(target_x_3, target_y_3, agent_item.x, agent_item.y)


        best_action = "stay"

        min_distance_index = find_best_reachable_index(can_reach_1, can_reach_2, can_reach_3, distance_1, distance_2, distance_3)

        if min_distance_index == 0:
            best_action = raw_name + " 1"
        if min_distance_index == 1:
            best_action = raw_name + " 2"
        if min_distance_index == 2:
            best_action = "get dirty plate"
        # print('----', best_action)
        return best_action

    

    target_x_1, target_y_1 = env._findPOitem(agent_item, macroActionDict[raw_name + " 1"])
    can_reach_1 = env._navigate(agent_item, target_x_1, target_y_1)
    distance_1 = env._calDistance(target_x_1, target_y_1, agent_item.x, agent_item.y)

    target_x_2, target_y_2 = env._findPOitem(agent_item, macroActionDict[raw_name + " 2"])
    can_reach_2 = env._navigate(agent_item, target_x_2, target_y_2)
    distance_2 = env._calDistance(target_x_2, target_y_2, agent_item.x, agent_item.y)

    best_action = "stay"
    if can_reach_1 == 4 and can_reach_2 != 4:
        best_action = raw_name + " 2"

    if can_reach_1 != 4 and can_reach_2 == 4:
        best_action = raw_name + " 1"

    if can_reach_1 != 4 and can_reach_2 != 4:
        if distance_1 <= distance_2:
            best_action = raw_name + " 1"

        else:
            best_action = raw_name + " 2"
    
    return best_action



def check_benevolence(env, best_action, action):
    env.reward = 0
    if action == macroActionDict[best_action] and macroActionDict[best_action] != 0:
        env.reward += 20
    return env.reward





def check_action_benevolence(env, action_left, action_right, firsttime_left_go_to_counter, firsttime_left_get_lettuce, firsttime_right_go_to_knife, firsttime_right_go_to_counter):

    agent_item = env.agent[1]
    human_agent = env.agent[0]


    counter1_x = 4
    counter1_y = 2

    counter2_x = 4
    counter2_y = 3

    counter3_x = 4
    counter3_y = 4

    counter4_x = 4
    counter4_y = 5

    counter5_x = 4
    counter5_y = 6

    counter6_x = 4
    counter6_y = 7

    counter7_x = 4
    counter7_y = 8
    
    counter8_x = 4
    counter8_y = 9

    counter9_x = 4
    counter9_y = 10

    counter10_x = 4
    counter10_y = 11

    counter11_x = 4
    counter11_y = 12

    counter12_x = 4
    counter12_y = 13


    counter1 = ITEMNAME[env.map[counter1_x][counter1_y]]
    counter2 = ITEMNAME[env.map[counter2_x][counter2_y]]
    counter3 = ITEMNAME[env.map[counter3_x][counter3_y]]
    counter4 = ITEMNAME[env.map[counter4_x][counter4_y]]
    counter5 = ITEMNAME[env.map[counter5_x][counter5_y]]
    counter6 = ITEMNAME[env.map[counter6_x][counter6_y]]
    counter7 = ITEMNAME[env.map[counter7_x][counter7_y]]
    counter8 = ITEMNAME[env.map[counter8_x][counter8_y]]
    counter9 = ITEMNAME[env.map[counter9_x][counter9_y]]
    counter10 = ITEMNAME[env.map[counter10_x][counter10_y]]
    counter11 = ITEMNAME[env.map[counter11_x][counter11_y]]
    counter12 = ITEMNAME[env.map[counter12_x][counter12_y]]



    reward_shaping_bonus = 0

    """右侧high benevolence"""
    counters = [counter1, counter2, counter3, counter4, counter5, counter6, counter7, counter8, counter9, counter10, counter11, counter12]
    if any(counter in ("lettuce") for counter in counters):
        best_action = intelligently_find_item_number(env, human_agent, "get lettuce")

        if firsttime_left_get_lettuce == True:
            reward_shaping_bonus = check_benevolence(env, best_action, action_left)
            if reward_shaping_bonus == 20:
                firsttime_left_get_lettuce = False

    if all(counter not in ("lettuce") for counter in counters):

        if agent_item.holding and isinstance(agent_item.holding, Lettuce):
            best_action = "go to counter"

            if firsttime_right_go_to_counter == True:
                reward_shaping_bonus = check_benevolence(env, best_action, action_right)
                if reward_shaping_bonus == 20:
                    firsttime_right_go_to_counter = False


        best_action = "go to counter"
        if firsttime_left_go_to_counter == True:
            reward_shaping_bonus = check_benevolence(env, best_action, action_left)
            if reward_shaping_bonus == 20:
                firsttime_left_go_to_counter = False


    return reward_shaping_bonus, firsttime_left_go_to_counter, firsttime_left_get_lettuce, firsttime_right_go_to_knife, firsttime_right_go_to_counter





class SingleAgentWrapper_Without_Latent(gym.Wrapper):
    """
    A wrapper to extract a single agent's perspective from a multi-agent environment.
    """
    def __init__(self, env, agent_index, other_agent_model=None):
        super(SingleAgentWrapper_Without_Latent, self).__init__(env)
        self.agent_index = agent_index
        self.observation_space = env.observation_space
        self.action_space = env.action_space
        self.other_agent_model = other_agent_model
        
        self.firsttime_left_go_to_counter = True
        self.firsttime_left_get_lettuce = True
        self.firsttime_right_go_to_knife = True
        self.firsttime_right_go_to_counter = True

        self.obs = None


    def reset(self):
        self.obs = self.env.reset()

        self.firsttime_left_go_to_counter = True
        self.firsttime_left_get_lettuce = True
        self.firsttime_right_go_to_knife = True
        self.firsttime_right_go_to_counter = True


        return self.obs[self.agent_index]

    def step(self, action):

        benevolence_reward = 0
        
        actions = [0, 0]

        other_agent_action = self.other_agent_model.predict(self.obs[1 - self.agent_index])

        actions[self.agent_index] = action

        actions[1 - self.agent_index] = other_agent_action[0]


        """下面代码是进行【合作】的reward shaping，以及对inconsistency进行惩罚的部分，暂时注释掉"""
        if self.agent_index == 1:
            action_right = action
            action_left = other_agent_action[0]

        if self.agent_index == 0:
            action_left = action
            action_right = other_agent_action[0]



        # benevolence_reward, self.firsttime_left_go_to_counter, self.firsttime_left_get_lettuce, self.firsttime_right_go_to_knife, self.firsttime_right_go_to_counter = check_action_benevolence(self.env, action_left, action_right, self.firsttime_left_go_to_counter, self.firsttime_left_get_lettuce, self.firsttime_right_go_to_knife, self.firsttime_right_go_to_counter)



        primary_actions = self.env._computeLowLevelActions(actions)

        self.obs, rewards, dones, info = self.env.step(primary_actions)

        self.obs = self.env._get_macro_obs()

        
        if self.agent_index == 0:
            return self.obs[self.agent_index], rewards[self.agent_index] + rewards[1 - self.agent_index], dones, info
        if self.agent_index == 1:
            return self.obs[self.agent_index], rewards[self.agent_index] + rewards[1 - self.agent_index], dones, info






class SingleAgentWrapper(gym.Wrapper):
    """
    A wrapper to extract a single agent's perspective from a multi-agent environment.
    """
    def __init__(self, env, partner_env, agent_index):
        super(SingleAgentWrapper, self).__init__(env)
        self.agent_index = agent_index
        self.observation_space = env.observation_space
        self.action_space = env.action_space
        
        self.firsttime_left_go_to_counter = True
        self.firsttime_left_get_lettuce = True
        self.firsttime_right_go_to_knife = True
        self.firsttime_right_go_to_counter = True

        self.obs = None


        agent_lists = [
            "final_trained_models/[MapA_lowuncertainty]MEP_seed15_teamReward/model_100000",
            "final_trained_models/[MapA_lowuncertainty]MEP_seed15_teamReward/model_200000",
            "final_trained_models/[MapA_lowuncertainty]MEP_seed15_teamReward/model_400000",
            "final_trained_models/[MapA_lowuncertainty]MEP_seed15_teamReward/model_2000000",
            "final_trained_models/[MapA_lowuncertainty]MEP_seed15_teamReward/model_6100000",
            "final_trained_models/[MapA_lowuncertainty]MEP_seed25_teamReward/model_100000",
            "final_trained_models/[MapA_lowuncertainty]MEP_seed25_teamReward/model_200000",
            "final_trained_models/[MapA_lowuncertainty]MEP_seed25_teamReward/model_400000",
            "final_trained_models/[MapA_lowuncertainty]MEP_seed25_teamReward/model_2000000",
            "final_trained_models/[MapA_lowuncertainty]MEP_seed25_teamReward/model_6100000",
            "final_trained_models/[MapA_lowuncertainty]MEP_seed35_teamReward/model_100000",
            "final_trained_models/[MapA_lowuncertainty]MEP_seed35_teamReward/model_200000",
            "final_trained_models/[MapA_lowuncertainty]MEP_seed35_teamReward/model_400000",
            "final_trained_models/[MapA_lowuncertainty]MEP_seed35_teamReward/model_2000000",
            "final_trained_models/[MapA_lowuncertainty]MEP_seed35_teamReward/model_6100000",
            "final_trained_models/[MapA_lowuncertainty]MEP_seed45_teamReward/model_100000",
            "final_trained_models/[MapA_lowuncertainty]MEP_seed45_teamReward/model_200000",
            "final_trained_models/[MapA_lowuncertainty]MEP_seed45_teamReward/model_400000",
            "final_trained_models/[MapA_lowuncertainty]MEP_seed45_teamReward/model_2000000",
            "final_trained_models/[MapA_lowuncertainty]MEP_seed45_teamReward/model_6100000",
            "final_trained_models/[MapA_lowuncertainty]MEP_seed55_teamReward/model_100000",
            "final_trained_models/[MapA_lowuncertainty]MEP_seed55_teamReward/model_200000",
            "final_trained_models/[MapA_lowuncertainty]MEP_seed55_teamReward/model_400000",
            "final_trained_models/[MapA_lowuncertainty]MEP_seed55_teamReward/model_2000000",
            "final_trained_models/[MapA_lowuncertainty]MEP_seed55_teamReward/model_6100000",
        ]

        # 加载所有模型
        self.models = {}
        for i, path in enumerate(agent_lists):
            model_name = f"model{i}"
            self.models[model_name] = PPO.load(path, env=partner_env)
            print(f"Loaded {model_name} from {path}")

        print(self.models)

    def set_partner_idx(self, new_partner_idx):
        self.partner_idx = new_partner_idx



    def reset(self):
        self.obs = self.env.reset()

        self.firsttime_left_go_to_counter = True
        self.firsttime_left_get_lettuce = True
        self.firsttime_right_go_to_knife = True
        self.firsttime_right_go_to_counter = True

        partner_idx = self.partner_idx

        # print(f"Selected teammate #{partner_idx}")

        self.other_agent_model = self.models["model"+str(partner_idx)]


        return self.obs[self.agent_index]

    def step(self, action):

        benevolence_reward = 0
        
        actions = [0, 0]

        other_agent_action = self.other_agent_model.predict(self.obs[1 - self.agent_index])

        actions[self.agent_index] = action

        actions[1 - self.agent_index] = other_agent_action[0]


        """下面代码是进行【合作】的reward shaping，以及对inconsistency进行惩罚的部分，暂时注释掉"""
        if self.agent_index == 1:
            action_right = action
            action_left = other_agent_action[0]

        if self.agent_index == 0:
            action_left = action
            action_right = other_agent_action[0]



        # benevolence_reward, self.firsttime_left_go_to_counter, self.firsttime_left_get_lettuce, self.firsttime_right_go_to_knife, self.firsttime_right_go_to_counter = check_action_benevolence(self.env, action_left, action_right, self.firsttime_left_go_to_counter, self.firsttime_left_get_lettuce, self.firsttime_right_go_to_knife, self.firsttime_right_go_to_counter)

        primary_actions, real_execute_macro_actions = self.env._computeLowLevelActions(actions)

        self.obs, rewards, dones, info = self.env.step(primary_actions)

        self.obs = self.env._get_macro_obs()

        
        if self.agent_index == 0:
            return self.obs[self.agent_index], rewards[self.agent_index] + rewards[1 - self.agent_index], dones, info
        if self.agent_index == 1:
            return self.obs[self.agent_index], rewards[self.agent_index] + rewards[1 - self.agent_index], dones, info




class EpisodeRewardCallback(BaseCallback):
    def __init__(self, save_path, save_freq=100000, verbose=0):
        super(EpisodeRewardCallback, self).__init__(verbose)
        self.save_path = save_path
        self.save_freq = save_freq
        self.step_counter = 0
        self.episode_rewards = []
        self.current_episode_reward = 0.0

        os.makedirs(self.save_path, exist_ok=True)

    def _on_step(self) -> bool:
        self.step_counter += 1
        self.current_episode_reward += self.locals['rewards'][0]

        # Check if episode is done
        if self.locals['dones'][0]:
            self.episode_rewards.append(self.current_episode_reward)
            self.current_episode_reward = 0.0

        # Save and plot every save_freq steps
        if self.step_counter % self.save_freq == 0:
            model_path = os.path.join(self.save_path, f'model_{self.step_counter}.zip')
            self.model.save(model_path)
            print(f"Step {self.step_counter}: Model saved at {model_path}")

            # Plot moving average of last 100 episode rewards
            if len(self.episode_rewards) >= 1:
                window = min(100, len(self.episode_rewards))
                moving_avg = [sum(self.episode_rewards[max(0, i - window + 1):i + 1]) / (i - max(0, i - window + 1) + 1)
                              for i in range(len(self.episode_rewards))]

                plt.figure(figsize=(10, 5))
                plt.plot(moving_avg, label=f"Moving Avg (last {window} episodes)")
                plt.xlabel("Episode")
                plt.ylabel("Average Reward")
                plt.title("Training Progress")
                plt.legend()
                plt.grid()
                plt.tight_layout()
                plt.savefig(os.path.join(self.save_path, f'avg_reward_{self.step_counter}.png'))
                plt.close()

        return True






rewardList = [{
    "minitask finished": 0,
    "minitask failed": 0,
    "metatask finished": 0,
    "metatask failed": 0,
    "goodtask finished": 10,
    "goodtask failed": 0,
    "subtask finished": 20,
    "subtask failed": 0,
    "correct delivery": 200,
    "wrong delivery": -50,
    "step penalty": -1,
    "penalize using dirty plate": 0,
    "penalize using bad lettuce": -20,
    "pick up bad lettuce": -100
},{
    "minitask finished": 0,
    "minitask failed": 0,
    "metatask finished": 0,
    "metatask failed": 0,
    "goodtask finished": 10,
    "goodtask failed": 0,
    "subtask finished": 20,
    "subtask failed": 0,
    "correct delivery": 200,
    "wrong delivery": -50,
    "step penalty": -1,
    "penalize using dirty plate": 0,
    "penalize using bad lettuce": 0,
    "pick up bad lettuce": 0
}]




mac_env_id = 'Overcooked-MA-v2'
env_params = {
    'grid_dim': [15, 15],
    'task': ["lettuce salad"],
    'rewardList': rewardList,
    'map_type': "A_lowuncertainty",
    'n_agent': 2,
    'obs_radius': 0,
    'mode': "vector",
    'debug': True
}

new_logger = configure('./logs/', ["csv", "tensorboard"])  # Remove "stdout" to prevent console logging


# Initialize shared environment
shared_env = gym.make(mac_env_id, **env_params)
shared_env.seed(SEED)
shared_env.action_space.seed(SEED)
shared_env.observation_space.seed(SEED)

print('=====================', shared_env._findItem(9, 10, "tomato"))

# Wrap each agent
env_agent_1 = SingleAgentWrapper_Without_Latent(shared_env, agent_index=1)


env_agent_0 = SingleAgentWrapper(shared_env, env_agent_1, agent_index=0)

ppo_params = {
    'learning_rate': 3e-4,
    'n_steps': 256,
    'batch_size': 128,
    'n_epochs': 10,
    'gamma': 0.95,
    'gae_lambda': 0.95,
    'clip_range': 0.3,
    'ent_coef': 0.02,
    # 'ent_coef': 0.05,
    'vf_coef': 0.5,
    'max_grad_norm': 0.5,
    'verbose': 0,
}


policy_kwargs = dict(
    net_arch=[dict(pi=[256, 128, 64], vf=[256, 128, 64])]
)


model = PPO("MlpPolicy", env_agent_0, policy_kwargs=policy_kwargs, **ppo_params)


# Training configuration
total_alternate_steps = 1000000  # Total training steps
alternate_interval = 10000  # Each agent trains for this many steps before switching


global_start_time = time.time()  # 记录整个训练开始的时间

def format_time(seconds):
    minutes = int(seconds // 60)
    secs = int(seconds % 60)
    return f"{minutes}分{secs}秒"


callback = EpisodeRewardCallback('final_trained_models/[MapA_lowuncertainty]MEP_teamReward')


mep_population1_1 = PPO.load("final_trained_models/[MapA_lowuncertainty]MEP_seed15_teamReward/model_100000", env=env_agent_0)
mep_population1_2 = PPO.load("final_trained_models/[MapA_lowuncertainty]MEP_seed15_teamReward/model_200000", env=env_agent_0)
mep_population1_3 = PPO.load("final_trained_models/[MapA_lowuncertainty]MEP_seed15_teamReward/model_400000", env=env_agent_0)
mep_population1_4 = PPO.load("final_trained_models/[MapA_lowuncertainty]MEP_seed15_teamReward/model_2000000", env=env_agent_0)
mep_population1_5 = PPO.load("final_trained_models/[MapA_lowuncertainty]MEP_seed15_teamReward/model_6100000", env=env_agent_0)


mep_population2_1 = PPO.load("final_trained_models/[MapA_lowuncertainty]MEP_seed25_teamReward/model_100000", env=env_agent_0)
mep_population2_2 = PPO.load("final_trained_models/[MapA_lowuncertainty]MEP_seed25_teamReward/model_200000", env=env_agent_0)
mep_population2_3 = PPO.load("final_trained_models/[MapA_lowuncertainty]MEP_seed25_teamReward/model_400000", env=env_agent_0)
mep_population2_4 = PPO.load("final_trained_models/[MapA_lowuncertainty]MEP_seed25_teamReward/model_2000000", env=env_agent_0)
mep_population2_5 = PPO.load("final_trained_models/[MapA_lowuncertainty]MEP_seed25_teamReward/model_6100000", env=env_agent_0)


mep_population3_1 = PPO.load("final_trained_models/[MapA_lowuncertainty]MEP_seed35_teamReward/model_100000", env=env_agent_0)
mep_population3_2 = PPO.load("final_trained_models/[MapA_lowuncertainty]MEP_seed35_teamReward/model_200000", env=env_agent_0)
mep_population3_3 = PPO.load("final_trained_models/[MapA_lowuncertainty]MEP_seed35_teamReward/model_400000", env=env_agent_0)
mep_population3_4 = PPO.load("final_trained_models/[MapA_lowuncertainty]MEP_seed35_teamReward/model_2000000", env=env_agent_0)
mep_population3_5 = PPO.load("final_trained_models/[MapA_lowuncertainty]MEP_seed35_teamReward/model_6100000", env=env_agent_0)


mep_population4_1 = PPO.load("final_trained_models/[MapA_lowuncertainty]MEP_seed45_teamReward/model_100000", env=env_agent_0)
mep_population4_2 = PPO.load("final_trained_models/[MapA_lowuncertainty]MEP_seed45_teamReward/model_200000", env=env_agent_0)
mep_population4_3 = PPO.load("final_trained_models/[MapA_lowuncertainty]MEP_seed45_teamReward/model_400000", env=env_agent_0)
mep_population4_4 = PPO.load("final_trained_models/[MapA_lowuncertainty]MEP_seed45_teamReward/model_2000000", env=env_agent_0)
mep_population4_5 = PPO.load("final_trained_models/[MapA_lowuncertainty]MEP_seed45_teamReward/model_6100000", env=env_agent_0)



mep_population5_1 = PPO.load("final_trained_models/[MapA_lowuncertainty]MEP_seed55_teamReward/model_100000", env=env_agent_0)
mep_population5_2 = PPO.load("final_trained_models/[MapA_lowuncertainty]MEP_seed55_teamReward/model_200000", env=env_agent_0)
mep_population5_3 = PPO.load("final_trained_models/[MapA_lowuncertainty]MEP_seed55_teamReward/model_400000", env=env_agent_0)
mep_population5_4 = PPO.load("final_trained_models/[MapA_lowuncertainty]MEP_seed55_teamReward/model_2000000", env=env_agent_0)
mep_population5_5 = PPO.load("final_trained_models/[MapA_lowuncertainty]MEP_seed55_teamReward/model_6100000", env=env_agent_0)


population = [mep_population1_1, mep_population1_2, mep_population1_3, mep_population1_4, mep_population1_5,
              mep_population2_1, mep_population2_2, mep_population2_3, mep_population2_4, mep_population2_5,
              mep_population3_1, mep_population3_2, mep_population3_3, mep_population3_4, mep_population3_5,
              mep_population4_1, mep_population4_2, mep_population4_3, mep_population4_4, mep_population4_5,
              mep_population5_1, mep_population5_2, mep_population5_3, mep_population5_4, mep_population5_5]







current_episode = 0
total_episode = 500000
while current_episode < total_episode:

    
    """MEP 选择partner"""
    partner_agent = prioritized_sampling(model, population, shared_env, 3)
    env_agent_0.set_partner_idx(partner_agent)
    model.set_env(env_agent_0)





    model.learn(total_timesteps=10000, callback=callback)
    
    current_episode += 50
    print('current_episode: ', current_episode)

    phase_end_time = time.time()
    total_duration = phase_end_time - global_start_time
    print(f"[🕒 累计训练时间] {format_time(total_duration)}")

