import torch
import numpy as np

from sklearn.preprocessing import StandardScaler
from sklearn.model_selection import train_test_split
from sklearn.neural_network import MLPClassifier
from sklearn.metrics import accuracy_score, confusion_matrix
import pdb
torch.set_num_threads(24)

real_data = np.load('./loan_cat.csv.npz', allow_pickle=True)['val']
test_real = real_data[:,:-1]
y_real = real_data[:,-1]

data_cat0 = torch.load('./loan_dataset/gen_data_cat_0_ratio_0.05.pth')
data_cat1 = torch.load('./gen_data_cat_1_ratio_0.05.pth')

num_sample = len(data_cat0) + len(data_cat1)

y = np.zeros(num_sample)
y[len(data_cat0):] = 1

data = torch.cat((data_cat0, data_cat1), 0)

scaler = StandardScaler()

norm_data = scaler.fit_transform(data)
norm_test = scaler.transform(test_real)

data_train, data_test, y_train, y_test = train_test_split(norm_data, y, test_size=0.2, random_state=42)

classifier = MLPClassifier(verbose = True,
                            max_iter=100,
                            tol = 0.001,
                            solver = 'adam',
                            hidden_layer_sizes=(128),
                            activation='relu')

classifier.fit(data_train, y_train)

y_hat = classifier.predict(data_test)

y_pred = classifier.predict(norm_test)

acc = accuracy_score(y_test, y_hat)
acc_test = accuracy_score(y_real, y_pred)
cm = confusion_matrix(y_test, y_hat)
cm_test = confusion_matrix(y_real, y_pred)

print('MLP Classifier ACC: ', acc * 100, acc_test*100)
print('Confusion Matrix (Gen): ', cm)
print('Confusion Matrix (Real): ', cm_test)