def get_job_name(params):
    if params['alg'] == 'bc':
        if params['env_type'] == 'bsuite':
            name_keys = ['width', 'depth', 'lr', 'norm']
        elif params['env_type'] == 'atari':
            name_keys = ['lr', 'norm']
        name = 'bc'

    elif params['alg'] == 'unc':
        if params['env_type'] == 'bsuite':
            name_keys = ['width', 'depth', 'lr',
                            'feature_dim', 'n_comp',
                            'noise_scale', 'prior_scale', 'norm', 'type']
        elif params['env_type'] == 'atari':
            name_keys = ['lr', 'feature_dim', 'n_comp',
                            'noise_scale', 'prior_scale', 'norm', 'type']
        name = 'unc'

    elif params['alg'] == 'rl':
        if params['env_type'] == 'bsuite':
            name_keys = ['learner', 'actor', 'epsilon', 'tau', 'alpha',
                            'target_update_period', 'discount', 'lr', 'seed', 'norm',
                            'wrap_unc']
        elif params['env_type'] == 'atari':
            name_keys = ['learner', 'actor', 'epsilon', 'tau', 'alpha',
                            'target_update_period', 'discount', 'lr', 'seed', 'norm',
                            'wrap_unc']
        name = 'rl'
    else:
        raise NotImplementedError

    for k in name_keys:
        name += '_' + k[:3] + '_' + str(params[k])

    if params['alg'] == 'rl':
        unc_params = prefix_params(params, 'unc_')
        unc_params.update({'alg': 'unc'})
        name += '-' + get_job_name(unc_params)

    return name

def prefix_params(params, prefix, keep_non_prefix = True):
    new_params = {}
    for k,v in params.items():
        if k.startswith(prefix):
            new_params[k[len(prefix):]] = v
    if keep_non_prefix:
        for k,v in params.items():
            if k not in new_params:
                new_params[k] = v
    return new_params


def get_data_params(params):
    if params['env_type'] == 'bsuite':
        data_params =  {k: params[k] for k in ('env_type', 'env_id', 
                            'train_type', 'train_seed', 'train_size')}
    elif params['env_type'] == 'atari':
        data_params = {k: params[k] for k in ('env_type', 'env_id', 'run')}
    else:
        raise NotImplementedError

    return data_params