import itertools
import os
from subprocess import Popen

if __name__ == '__main__':

    grid = {
        "env_id": ['cartpole', 'catch'],
        "env_noise": [0.0,],
        "mix_type": ['uni', 'med', 'uni_med', 'uni_exp', 'med_seed'],
        "seed": list(range(0,50,5)),
        "data_size": [20000, 50000, 100000]
    }

    grid_setups = list(
        dict(zip(grid.keys(), values)) for values in itertools.product(*grid.values())
    )

    for i in range(len(grid_setups)):
        print('------------------')
        print(grid_setups[i])
        print('------------------')

        cmd = ['python', 'generate_mix_data.py']
        for k, v in grid_setups[i].items():
            cmd.append('-o')
            cmd.append(str(k))
            cmd.append(str(v))
            
        env = os.environ.copy()
        p = Popen(cmd, env=env)
        p.communicate()