# Heating up Decision Boundaries

This repository contains the source code of the NeuRips 2020 submission 'Heating up decision boundaries: some aspects of adversarial examples, compression and generalization bounds'.

In this work, we consider an MLP model as proof of principle trained on planar geometric data, LeNet-5 and basic CNN architectures trained on MNIST and finally a Wide Residual Network 28-10 and 32, 44 and 56 layered ResNets trained on CIFAR10.

Our analysis of said models includes mainly an evaluation of the isocapacitory and isoperimetric bound. For the Lenet-5 model we also considered the models robustness for various kind of data corruption.

### Requirements

- **torch 1.5.0**
- **torchvision 0.6.0**
- **numpy 1.18.2**
- **scipy 1.4.1**
- **tensorboard 2.2.1**
- **matplotlib 3.1.2**
- **matplotlib-label-lines 0.3.8**

### Instructions

Please find training code on the according directory. Options are MNIST or CIFAR10, with model and training method availabilities noted in the respective 'main.py'. Note that the parameters of the CIFAR10 training may be adjusted in the 'config.py' file in 'train/cifar10/'.

To evaluate quantities such as isocapacitory bounds, isoperimetric saturation etc, please find the according code in 'explorations/' and the desired subdirectory 'cifar10/', 'mnist/' for common and 'toydata/' for purely geometric examples.

We provide trained models used in our experiments (LeNet-5 architectures) for MNIST in the directory 'data/saved_models/mnist/'.

