import os
from datetime import datetime
import json


def save_config(config, mode):
    output_path = config.get("experiment_path").format(**config)
    os.makedirs(output_path, exist_ok=True)
    config_path = os.path.join(
        output_path,
        f'{mode}_{datetime.now().strftime("%Y-%m-%d_%H-%M-%S")}_config.json',
    )
    with open(config_path, "w") as f:
        json.dump(config, f, indent=4)
