import re
import httpx
import openai
from openai import OpenAI

def convert_to_text_format(tables):
    for table_dict in tables:
        # 提取标题和表格
        title = table_dict['ori_title']
        df = table_dict['table']

        # 构建标题行
        text = f"table caption : {title}.\n"
        # text = ''
        cols = 'col: ' + " | ".join(df.columns[1:])
        text += f"{cols}\n"

        # 构建每一行的数据
        for index, row in df.iterrows():
            row_data = f'row {index+1} : ' + " | ".join([str(row[col]) for col in df.columns[1:]])
            text += f"{row_data}\n"

        # 打印结果
        return text

def extract_sql_and_decompose(text):
    # Regular expressions to match SQL and decomposition sections
    sql_pattern = r'SQL:\s*(.*?)\s*Decompose:'
    decompose_pattern = r'Decompose:\s*(.*?)(?:\s*#|$)'

    # Extract SQL statement
    sql_match = re.search(sql_pattern, text, re.DOTALL)
    sql_statement = sql_match.group(1).strip() if sql_match else None

    # Extract decomposition steps
    decompose_match = re.search(decompose_pattern, text, re.DOTALL)
    decompose_text = decompose_match.group(1).strip() if decompose_match else None

    # # Split decomposition steps into a list
    # decompose_steps = [step.strip() for step in decompose_text.split('\n')] if decompose_text else []

    return sql_statement, decompose_text

def get_sql(question, title, table):
    try:
        with open('/home/yangzhen/code/tablellm/prompt/wtq/generate_sql.txt') as f:
            prompt_context = f.read()
        prompt = prompt_context.format(TITLE=title, TABLE=table, QUESTION=question)
        messages = [{"role": "user", "content": prompt}]
        api_key = 'sk-WXHpiXK1XnYZ0pffA5E3Cf358a93469cB50987Bf161041C3'
        client = OpenAI(
            base_url="https://threefive.gpt7.link/v1",
            api_key=api_key,
            http_client=httpx.Client(
                base_url="https://threefive.gpt7.link/v1",
                follow_redirects=True,
            ),
        )
        completion = client.chat.completions.create(
            model='gpt-3.5-turbo-0613',
            messages=messages,
            temperature=0.8,
            max_tokens=4980
        )
        # api_key = 'sk-YangZhen_230909_jyCRb1M58DIlmLfuvutK'
        # base_url = 'https://chat.aitsc.top:10001/chatapi/nostat/v1'
        # model = 'glm-4-public'
        # client = OpenAI(api_key=api_key, base_url=base_url)
        # completion = client.chat.completions.create(
        #     model=model,
        #     messages=messages,
        #     temperature=0.4,
        #     max_tokens=4980,
        # )
        result = completion.choices[0].message.content
        sql_text,decompose_text = extract_sql_and_decompose(result)
        if sql_text != None and decompose_text != None:
            return sql_text, decompose_text
    except Exception as e:
        print('get_sql error', e)
        return '', ''

def get_sql_tabfact(question, title, table):
    try:
        with open('/home/yangzhen/code/tablellm/prompt/tabfact/generate_sql.txt') as f:
            prompt_context = f.read()
        prompt = prompt_context.format(TITLE=title, TABLE=table, QUESTION=question)
        messages = [{"role": "user", "content": prompt}]
        api_key = 'sk-WXHpiXK1XnYZ0pffA5E3Cf358a93469cB50987Bf161041C3'
        client = OpenAI(
            base_url="https://threefive.gpt7.link/v1",
            api_key=api_key,
            http_client=httpx.Client(
                base_url="https://threefive.gpt7.link/v1",
                follow_redirects=True,
            ),
        )
        completion = client.chat.completions.create(
            model='gpt-3.5-turbo',
            messages=messages,
            temperature=0.4,
            max_tokens=4980
        )
        # api_key = 'sk-YangZhen_230909_jyCRb1M58DIlmLfuvutK'
        # base_url = 'https://chat.aitsc.top:10001/chatapi/nostat/v1'
        # model = 'glm-4-public'
        # client = OpenAI(api_key=api_key, base_url=base_url)
        # completion = client.chat.completions.create(
        #     model=model,
        #     messages=messages,
        #     temperature=0.4,
        #     max_tokens=4980,
        # )
        result = completion.choices[0].message.content
        sql_text,decompose_text = extract_sql_and_decompose(result)
        if sql_text != None and decompose_text != None:
            return sql_text, decompose_text
    except Exception as e:
        print('get_sql error', e)
        return '', ''

def generate_sql_answer(question, title, table, sql, decompose):
    with open('/home/yangzhen/code/tablellm/prompt/wtq/generate_sql_answer.txt') as f:
        prompt_context = f.read()
    # table2sql = convert_to_text_format(db.tables)
    prompt = prompt_context.format(TITLE=title, TABLE=table, QUESTION=question, SQL=sql, DECOMPOSE=decompose)
    messages = [{"role": "user", "content": prompt}]
    try:
        # api_key = 'sk-YangZhen_230909_jyCRb1M58DIlmLfuvutK'
        # base_url = 'https://chat.aitsc.top:10001/chatapi/nostat/v1'
        # model = 'glm-4-public'
        # client = OpenAI(api_key=api_key, base_url=base_url)
        # completion = client.chat.completions.create(
        #     model=model,
        #     messages=messages,
        #     temperature=0.4,
        #     max_tokens=4980,
        # )
        api_key = 'sk-WXHpiXK1XnYZ0pffA5E3Cf358a93469cB50987Bf161041C3'
        client = OpenAI(
            base_url="https://threefive.gpt7.link/v1",
            api_key=api_key,
            http_client=httpx.Client(
                base_url="https://threefive.gpt7.link/v1",
                follow_redirects=True,
            ),
        )
        completion = client.chat.completions.create(
            model='gpt-3.5-turbo',
            messages=messages,
            temperature=0.4,
            max_tokens=4980
        )
        result = completion.choices[0].message.content
        if 'Final Answer: ' in result and result != None:
            #return result.split('Final Answer: ')[1],completion
            return result, completion
    except Exception as e:
        print('generate_answer error', e)
        return 'error','error'