# TableLLM Repository

## 🚀 Installation

### 🛠 Clone the Repository

Start by cloning the repository to your local machine:

```bash
git clone https://github.com/Leolty/tablellm.git
cd tablellm
```

### 📦 Install Dependencies

Create and activate a new environment, and install the required packages:

```bash
conda create -n tablellm python=3.10
conda activate tablellm
pip install -r requirements.txt
```

## 🗂 Data

Unzip the dataset provided in the repository:

```bash
unzip assets/data.zip
```

After unzipping, you should have the following files:

```
└── data
    ├── wtq.json
    ├── tabfact.json
```

## 🔬 Experimentation

### 🔄 Reproducing the Results

For replicating our study's findings, navigate to the [scripts](scripts) folder:

- [run_cot_triple.py](scripts/all_dp.sh): Runs direct prompting on all wtq datasets.
- run_agent_triple.py: Runs python shell agent on all wtq datasets.

Detailed explanations of parameters can be found in [run_cot_triple.py](run_cot_triple.py) and [run_agent_triple.py](run_agent_triple.py).

Note: The result of our methods will public after review.
